ORCA/M Asm65816 2.1.0

0001 0000                       title 'Tool Locator         GS ROM 3.0'
0002 0000              ****************************************************************
0003 0000              *                                                              *
0004 0000              *                     Tool Locator                             *
0005 0000              *                                                              *
0006 0000              ****************************************************************
0007 0000
0008 0000
0009 0000              ****************************************************************
0010 0000              *                                                              *
0011 0000              *                  Copyright (C) 1985-1989                     *
0012 0000              *                  All Rights Reserved                         *
0013 0000              *                  Apple Computer, Inc.                        *
0014 0000              *                                                              *
0015 0000              ****************************************************************
0016 0000
0017 0000              ****************************************************************
0018 0000              *
0019 0000              * Change History
0020 0000              *
0021 0000              * ?? ??? 86	Steven Glass
0022 0000              *
0023 0000              * Original ROM release
0024 0000              *
0025 0000              * ?? ??? 87	Steven Glass
0026 0000              *
0027 0000              * Release for rom 2.0
0028 0000              *
0029 0000              * ?? Oct 87	Steven Glass
0030 0000              *
0031 0000              * Code that was in patch is integrated with ROM code for 
0032 0000              * first time.
0033 0000              *
0034 0000              * ?? Feb 88	Steven Glass
0035 0000              *
0036 0000              * Code converted to work with MAX
0037 0000              *
0038 0000              * 23 Oct 88	Steven Glass
0039 0000              *
0040 0000              * Added MessageByName.
0041 0000              * Changed size of default TPT from 32 to 48.
0042 0000              *
0043 0000              * 04 Nov 88	Steven Glass
0044 0000              *
0045 0000              * Incorporated ResetUserPtr into TLStartup.
0046 0000              *
0047 0000              * 07 Dec 88	Steven Glass
0048 0000              *
0049 0000              * Changed code that calls bootinit routine so that it never calls
0050 0000              * the memory manager boot init routine in ROM.
0051 0000              *
0052 0000              * 19 Apr 89	Steven Glass
0053 0000              *
0054 0000              * Add AppleIIForever Vector.
0055 0000              *
0056 0000              * 26-Sep-90	Dave Lyons
0057 0000              *
0058 0000              * Changed _SysDeathMgr to _SysFailMgr so this file will build
0059 0000              * with current interfaces.
0060 0000              *
0061 0000              * 6-Jun-91	Dave Lyons
0062 0000              *
0063 0000              * Added SANEShutDown call at the beginning of TLShutDown.
0064 0000              *
0065 0000              * 14-Sep-91	Dave Lyons
0066 0000              *
0067 0000              * Made TLShutDown call QDAuxShutDown for some BONEHEADS who
0068 0000              * are making ShutDownTools shut down the tool locator, and
0069 0000              * *then* they are shutting down QuickDraw, which would have
0070 0000              * shut down QDAux for them, but it's already gone.  (They
0071 0000              * never asked for QDAux in the first place, but Window Mgr
0072 0000              * loaded it so AlertWindow could use icons.)
0073 0000              *
0074 0000              ****************************************************************
0075 0000
0076 0000
0077 0000                       eject 
0078 0000              ****************************************************************
0079 0000              *
0080 0000              * Terminology
0081 0000              *
0082 0000              * The Tool Pointer Table (TPT) is the table of pointers to the
0083 0000              *        individual Function Pointer Tables.
0084 0000              * A Function Pointer Table (FPT) is the table of pointers to the
0085 0000              *        to the individual functions in a single tool set.
0086 0000              * The Work Area Pointer Table (WAP Table) is the table of longs
0087 0000              *        that are used by individual tools to store information
0088 0000              *        without having access to permenent memory.  Tools usually
0089 0000              *        keep the address of their direct page or a handle to some 
0090 0000              *        other data here.  The value of a tools WAP is always put
0091 0000              *        in the A & X registers when a function of the tool is 
0092 0000              *        called.
0093 0000              *
0094 0000              * Included in this file is the source to the tool dispatcher, 
0095 0000              * the tool init routine (SpecialInit) and the Tool Locator
0096 0000              * calls.
0097 0000              *
0098 0000              * Tool Locator has the following calls:
0099 0000              *
0100 0000              *   1     TLBootInit
0101 0000              *   2     TLApInit
0102 0000              *   3     TLApShutDown
0103 0000              *   4     TLVersion
0104 0000              *   5     TLReset
0105 0000              *   6     TLStatus
0106 0000              *   9     GetTSPtr
0107 0000              *   10    SetTSPtr
0108 0000              *   11    GetFuncPtr
0109 0000              *   12    GetWAP
0110 0000              *   13    SetWAP
0111 0000              *   14    LoadTools
0112 0000              *   15    LoadOneTool
0113 0000              *   16    UnloadOneTool
0114 0000              *   17    TLMountVolume
0115 0000              *   18    TLTextMountVolume
0116 0000              *   19    SaveTextState
0117 0000              *   20    RestoreTextState
0118 0000              *   21    MessageCenter
0119 0000              *   22    SetDefaultTPt
0120 0000              *
0121 0000              *
0122 0000              *
0123 0000              *
0124 0000              ****************************************************************
0125 0000
0126 0000              ****************************************************************
0127 0000              *
0128 0000              * How the Dispatching mechanism works:
0129 0000              *
0130 0000              *     There are four entry points in Bank E0
0131 0000              *
0132 0000              *         SystemDispatch
0133 0000              *         Glue Dispatch
0134 0000              *         UserDispatch
0135 0000              *         Glue UserDispatch
0136 0000              *
0137 0000              *     The only difference between the system and user entry
0138 0000              *     points is that the pointers come out of different
0139 0000              *     tables.
0140 0000              *
0141 0000              *     The calling program must call these dispatchers in
0142 0000              *     full native mode as follows:
0143 0000              *
0144 0000              *         ldx #FuncNum*256+TSNum
0145 0000              *         jsl Dispatch
0146 0000              *
0147 0000              *     The difference between Dispatch and AutoPopDispatch is that
0148 0000              *     there is one extra return address on the stack at the
0149 0000              *     time of the auto pop dispatch call.  The Dispatch entry point
0150 0000              *     puts an extra rtl address on the stack so that any parameters
0151 0000              *     to a function are the same depth in the stack no matter what
0152 0000              *     entry point is used.
0153 0000              *
0154 0000              ****************************************************************
0155 0000
0156 0000                       blanks off 
0157 0000                       string asis 
0158 0000
0159 0000                       print push 
0160 0000                       print off 
0161 0000                       include 'all.macros' 
0162 0000                       include '::sys.equs.asm' 
0163 0000                       INCLUDE 'e16.memory' 
0164 0000
0165 0000                       include 'tl.equates.asm' 
0166 0000                       print pop 
0167 0000
0168 0000
0169 0000
0170 0000
0171 0000                       title ' Imported Addresses'
0172 0000              ;-----------------------------------------------
0173 0000              ;
0174 0000              ;   Imported addresses
0175 0000              ;
0176 0000              ;-----------------------------------------------
0177 0000
0178 0000                       IMPORT EndCall4 
0179 0000                       IMPORT EndCall8 
0180 0000                       IMPORT ErrOut4 
0181 0000                       IMPORT ErrOut8 
0182 0000                       IMPORT oBusyErr4 
0183 0000                       IMPORT oEndCall0 
0184 0000
0185 0000                       title ' Bank FE Vectors'
0186 0000
0187 0000              ****************************************************************
0188 0000              *
0189 0000              BankFEVectors PROC 
0190 0000              *
0191 0000              * These are the only public entry points into the bank FE
0192 0000              * ROM.  All other entry is through the tool locator and 
0193 0000              * associated mechinisms.
0194 0000              *
0195 0000              *
0196 0000              * Inputs:
0197 0000              *	none
0198 0000              *
0199 0000              * Outputs:
0200 0000              *	none
0201 0000              *
0202 0000              * External Refs:
0203 0000                       import SpecialInit 
0204 0000                       import InstallPeekerDA 
0205 0000                       import DAHandler 
0206 0000                       import ATSReset 
0207 0000                       import ATHReset 
0208 0000                       import STool 
0209 0000                       import AppleIIForever 
0210 0000              *
0211 0000              * Entry Points:
0212 0000              *	none
0213 0000              *
0214 0000                       longa on                       ; mode
0215 0000                       longi on
0216 0000              *
0217 0000              * Change History
0218 0000              *
0219 0000              * 03 Nov 88	STeven Glass & Joe Bo
0220 0000              *
0221 0000              * Added a new vectors for entry into ADB tool.
0222 0000              *
0223 0000              ****************************************************************
0224 0000
0225 0000
0226 0000 5C 1C 00 FE           jml   SpecialInit
0227 0004 5C 8A 17 FC           jml   InstallPeekerDA
0228 0008 5C 28 CF FE           jml   DAHandler
0229 000C 5C FD E3 FD           jml   ATHReset                 ; apple talks hard reset
0230 0010 5C 00 E4 FD           jml   ATSReset                 ; apple talks soft reset
0231 0014 5C 4E D9 FC           jml   STool                    ; Special entry into ADB tool added 3 Nov 88 by Joe and Steve
0232 0018 5C C6 07 FE           jml   AppleIIForever
0233 001C
0234 001C
0235 001C
0236 001C                       title ' SpecialInit'
0237 001C              ****************************************************************
0238 001C              *
0239 001C              SpecialInit proc  
0240 001C              *
0241 001C              * This routine copies the pointer to the ROM based TPT to
0242 001C              * and U_TPT pointers to RAM.
0243 001C              *
0244 001C              * It also fixes the RAM vectors in bank E0 to point to this
0245 001C              * code.
0246 001C              *
0247 001C              * This is called and returns in 8 bit native mode.
0248 001C              *
0249 001C              * Inputs:
0250 001C              *	none
0251 001C              *
0252 001C              * Outputs:
0253 001C              *	none
0254 001C              *
0255 001C              * External Refs:
0256 001C                       import oErrOut 
0257 001C                       import ROM_TPT 
0258 001C                       import UserDummyTable 
0259 001C                       import Dispatch 
0260 001C                       import GluDispatch 
0261 001C                       import U_Dispatch 
0262 001C                       import U_GluDispatch 
0263 001C                       import iToolboxPatcher 
0264 001C                       import FixOSStackEntry 
0265 001C              *
0266 001C              * Entry Points:
0267 001C              *	none
0268 001C              *
0269 001C                       longa on                       ; mode
0270 001C                       longi on
0271 001C              *
0272 001C              * Modification History
0273 001C              *
0274 001C              *  17 May 86   Reset user pointers was being called before
0275 001C              *              the memory manager was initialized.
0276 001C              *  20 May 86   User TPTPtr is now initialized before the TL
0277 001C              *              boot init call is made.
0278 001C              *
0279 001C              *  04 Dec 86   I do not make the WAPTPtr point to the top
0280 001C              *              of the ROM any more.  I rely on the BootInit
0281 001C              *              call to set it correctly.
0282 001C              *
0283 001C              *              Added JSL to RomToolHook, a vector in bank E1
0284 001C              *              which installs any ROM tools in from the lower banks
0285 001C              *              that may be present.
0286 001C              *
0287 001C              *  20 Jan 87   Oops, we found that some fools were coming in in
0288 001C              *              mixed native mode and relying on the code in the dispatcher
0289 001C              *              to clear the m-bit.  With great regret and trepidation
0290 001C              *              I put the rep #$30 back into the dispatcher at all
0291 001C              *              four entry points.
0292 001C              *
0293 001C              * 10 Jun 88    Init code uses oErrOut in this bank rather than bank
0294 001C              *              FF for strip vectors.
0295 001C              *
0296 001C              * 11 Oct 88    Added code to init the LLToolboxVector in bank $E1.
0297 001C              *
0298 001C              ****************************************************************
0299 001C
0300 001C
0301 001C              ;----------------------------------------------------
0302 001C              ;
0303 001C              ; Fern calls me in Native mode with m and x set to 1
0304 001C              ;
0305 001C C2 30                 rep   #%00110000
0306 001E                       longa on
0307 001E                       longi on
0308 001E
0309 001E A2 0E 00              ldx   #14                      ; put the jump table in
0310 0021 BF 81 00 FE  OtherLoop lda   >JumpTable,x            ; ram
0311 0025 9F 00 00 E1           sta   >RealDispatch,x
0312 0029 CA                    dex   
0313 002A CA                    dex   
0314 002B 10 F4                 bpl   OtherLoop
0315 002D
0316 002D              ;---------------------------------------------
0317 002D              ;
0318 002D              ; Put the pointers to the TPT and dummy WAPT
0319 002D              ; into RAM.
0320 002D              ;
0321 002D A9 39 01              lda   #ROM_TPT
0322 0030 8F C0 03 E1           sta   >TPTPtr
0323 0034 A9 FE 00              lda   #^ROM_TPT
0324 0037 8F C2 03 E1           sta   >TPTPtr+2
0325 003B
0326 003B 8F CA 03 E1           sta   >WAPTPtr+2               ; set high word of this pointer
0327 003F              *			; to prevent accidental access
0328 003F              *			; to any softswitches
0329 003F
0330 003F A9 69 02              lda   #UserDummyTable          ; set this first time
0331 0042 8F C4 03 E1           sta   >U_TPTPtr
0332 0046 A9 FE 00              lda   #^UserDummyTable
0333 0049 8F C6 03 E1           sta   >U_TPTPtr+2
0334 004D
0335 004D
0336 004D              ;--------------------------------------------------------
0337 004D              ;
0338 004D              ; Fix the end call vector
0339 004D              ;
0340 004D A2 06 00              ldx   #6                       ; put the Strip vectors in
0341 0050 BF 91 00 FE  LastLoop lda   >EndCallVector,x         ; place
0342 0054 9F 80 01 E1           sta   >ToBusyStrip,x
0343 0058 CA                    dex   
0344 0059 CA                    dex   
0345 005A 10 F4                 bpl   LastLoop
0346 005C
0347 005C
0348 005C              ;-----------------------------------------------------------
0349 005C              ;
0350 005C              ; Init the LLToolboxVector
0351 005C              ;
0352 005C AF 99 00 FE           lda   >ToToolboxPatcher
0353 0060 8F BC 01 E1           sta   >LLToolboxVector
0354 0064 AF 9B 00 FE           lda   >ToToolboxPatcher+2
0355 0068 8F BE 01 E1           sta   >LLToolboxVector+2
0356 006C
0357 006C
0358 006C 22 A6 E6 FC           jsl   FixOSStackEntry
0359 0070
0360 0070
0361 0070              ;-----------------------------------------------------------
0362 0070              ;
0363 0070              ; Init all the tools.
0364 0070              ;
0365 0070
0366 0070
0367 0070 A2 01 01              ldx   #$0101
0368 0073 22 00 00 E1           jsl   RealDispatch
0369 0077 B0 05                 bcs   SomethingsWrong
0370 0079
0371 0079 22 7C 00 E1           jsl   RomToolHook
0372 007D 18                    clc   
0373 007E
0374 007E
0375 007E              SomethingsWrong                         ; 
0376 007E E2 30                 sep   #%00110000               ; set back to 8 bit m and x for Fern
0377 0080                       longa off
0378 0080                       longi off
0379 0080
0380 0080 6B                    rtl   
0381 0081
0382 0081              JumpTable                               ; 
0383 0081 5C C5 00 FE           jml   Dispatch
0384 0085 5C C2 00 FE           jml   GluDispatch
0385 0089 5C A0 00 FE           jml   U_Dispatch
0386 008D 5C 9D 00 FE           jml   U_GluDispatch
0387 0091
0388 0091              EndCallVector                           ; 
0389 0091 22 68 00 E1           jsl   DecBusyFlg
0390 0095 5C B4 FC FE           jml   oErrOut
0391 0099
0392 0099
0393 0099 5C 70 0B FE  ToToolboxPatcher jml   iToolBoxPatcher
0394 009D
0395 009D                       ENDP 
0396 009D
0397 009D
0398 009D
0399 009D                       title 'U_Dispatch and U_GluDispatch'
0400 009D              ****************************************************************
0401 009D              *
0402 009D              TheU_Dispatcher PROC  
0403 009D              *
0404 009D              * Called with a JSL after loading x with
0405 009D              * the TSNum, FuncNum
0406 009D              *
0407 009D              *
0408 009D              * Called directly and makes the stack look as follows
0409 009D              *
0410 009D              *       Real Return Address
0411 009D              *       TOS
0412 009D              *
0413 009D              * The ToolNum FuncNum are in the x-reg.
0414 009D              *
0415 009D              * Function expects
0416 009D              *       Real Return Address
0417 009D              *       Another Return Address
0418 009D              *       TOS
0419 009D              *
0420 009D              * Inputs:
0421 009D              *	x-reg  Call Number
0422 009D              *
0423 009D              * Outputs:
0424 009D              *	x-reg  Unchanged
0425 009D              *	a-reg  trashed
0426 009D              *
0427 009D              * External Refs:
0428 009D                       IMPORT UserEntry 
0429 009D                       IMPORT AnRTL 
0430 009D              *
0431 009D              * Entry Points:
0432 009D                       ENTRY U_Dispatch 
0433 009D                       ENTRY U_GluDispatch 
0434 009D              *
0435 009D                       longa on                       ; mode
0436 009D                       longi on
0437 009D              *
0438 009D              *
0439 009D              * Modification History
0440 009D              *
0441 009D              *  04 Dec 86   SEG	   Removed code which returned error if
0442 009D              *	   called from emulation.  This speeds
0443 009D              *	   dispatch up by a few cycles and saves
0444 009D              *	   some code.
0445 009D              *
0446 009D              * 20 Jan 87	Steven Glass
0447 009D              *
0448 009D              * Started code with REP #30 because some dumb apps called tools
0449 009D              * in mixed native mode and had luckily worked.
0450 009D              *
0451 009D              * 09 Jul 88	Steven Glass
0452 009D              *
0453 009D              * Andy Stadler pointed out that it takes fewer cycles to 
0454 009D              * build the stack frame by loads and pushes than it does 
0455 009D              * by subtracting and then loading and storing.
0456 009D              *
0457 009D              ****************************************************************
0458 009D
0459 009D
0460 009D              WAPTRef  equ   1                        ; 1    4
0461 009D              TPTRef   equ   WAPTRef+4                ; 5    3
0462 009D              RetADR1  equ   TPTRef+3                 ; 8    4
0463 009D              RetADR2  equ   RetADR1+3                ;11
0464 009D
0465 009D              WorkSpace equ   RetADR2-WAPTRef
0466 009D              FTableRef equ   TPTRef
0467 009D
0468 009D 8B           U_GluDispatch phb                       ; push an extra byte on the stack and
0469 009E 80 06                 bra   GluJoin                  ; join the rest.
0470 00A0              U_Dispatch  
0471 00A0 F4 01 FE              pea   AnRTL-1>>8               ; put the address of an RTL on the stack
0472 00A3 F4 00 37              pea   AnRTL-1<<8               ; and one more byte too.
0473 00A6
0474 00A6
0475 00A6 C2 30        GluJoin  rep   #$30                     ; force full native mode
0476 00A8 AF C4 03 E1           lda   >U_TPTPtr                ; put low word of TPT on stack
0477 00AC 48                    pha                            ; get middle and high bytes in place
0478 00AD AF C5 03 E1           lda   >U_TPTPtr+1
0479 00B1 83 02                 sta   2,s
0480 00B3 AF CE 03 E1           lda   >U_WAPTPtr+2             ; get WAPT ptr on stack
0481 00B7 48                    pha   
0482 00B8 AF CC 03 E1           lda   >U_WAPTPtr
0483 00BC 48                    pha   
0484 00BD 3B                    tsc                            ; turn stack to d-page.
0485 00BE 0B                    phd   
0486 00BF 5B                    tcd   
0487 00C0
0488 00C0 80 23                 bra   UserEntry
0489 00C2
0490 00C2                       ENDP 
0491 00C2
0492 00C2
0493 00C2                       title 'Dispatch and GluDispatch'
0494 00C2              ****************************************************************
0495 00C2              *
0496 00C2              TheDispatcher PROC  
0497 00C2              *
0498 00C2              * Called with a JSL after pushing a word on the stack
0499 00C2              * which is the TSNum and the FuncNum
0500 00C2              *
0501 00C2              *
0502 00C2              * Called directly and makes the stack look as follows
0503 00C2              *
0504 00C2              *       Real Return Address
0505 00C2              *       TOS
0506 00C2              *
0507 00C2              * The ToolNum FuncNum are in the x-reg.
0508 00C2              *
0509 00C2              * Function expects
0510 00C2              *       Real Return Address
0511 00C2              *       Another Return Address
0512 00C2              *       TOS
0513 00C2              *
0514 00C2              * Inputs:
0515 00C2              *	x-reg  Call Number
0516 00C2              *
0517 00C2              * Outputs:
0518 00C2              *	a-reg  Low Word of WAP
0519 00C2              *	y-reg  High word of WAP
0520 00C2              *	x-reg  Unchanged
0521 00C2              *
0522 00C2              * External Refs:
0523 00C2              *	none
0524 00C2              *
0525 00C2              * Entry Points:
0526 00C2                       entry GluDispatch 
0527 00C2                       entry Dispatch 
0528 00C2                       entry UserENTRY 
0529 00C2                       entry BadToolNumber 
0530 00C2                       entry BadFunctionNumber 
0531 00C2                       entry AnRTL 
0532 00C2
0533 00C2              *
0534 00C2                       longa on                       ; mode
0535 00C2                       longi on
0536 00C2              *
0537 00C2              *
0538 00C2              * Modification History
0539 00C2              *
0540 00C2              * 04 Dec 86   SEG	   Removed code which returned error if
0541 00C2              *	   called from emulation.  This speeds
0542 00C2              *	   dispatch up by a few cycles and saves
0543 00C2              *	   some code.
0544 00C2              *
0545 00C2              *
0546 00C2              * 20 Jan 87	Steven Glass
0547 00C2              *
0548 00C2              * Started code with REP #30 because some dumb apps called tools
0549 00C2              * in mixed native mode and had luckily worked.
0550 00C2              *
0551 00C2              *
0552 00C2              * 09 Jul 88	Steven Glass
0553 00C2              *
0554 00C2              * Andy Stadler pointed out that it takes fewer cycles to 
0555 00C2              * build the stack frame by loads and pushes than it does 
0556 00C2              * by subtracting and then loading and storing.
0557 00C2              *
0558 00C2              ****************************************************************
0559 00C2
0560 00C2
0561 00C2              WAPTRef  equ   1                        ; 1    4
0562 00C2              TPTRef   equ   WAPTRef+4                ; 5    3
0563 00C2              RetADR1  equ   TPTRef+3                 ; 8    4
0564 00C2              RetADR2  equ   RetADR1+3                ;11
0565 00C2
0566 00C2              WorkSpace equ   RetADR2-WAPTRef
0567 00C2              FTableRef equ   TPTRef
0568 00C2
0569 00C2
0570 00C2 8B           GluDispatch phb                         ; push an extra byte on the stack and
0571 00C3 80 06                 bra   GluJoin                  ; join the rest.
0572 00C5              Dispatch  
0573 00C5 F4 01 FE              pea   AnRTL-1>>8               ; put the address of an RTL on the stack
0574 00C8 F4 00 37              pea   AnRTL-1<<8               ; and one more byte too.
0575 00CB
0576 00CB
0577 00CB C2 30        GluJoin  rep   #$30                     ; force full native mode
0578 00CD AF C0 03 E1           lda   >TPTPtr                  ; put low word of TPT on stack
0579 00D1 48                    pha                            ; get middle and high bytes in place
0580 00D2 AF C1 03 E1           lda   >TPTPtr+1
0581 00D6 83 02                 sta   2,s
0582 00D8 AF CA 03 E1           lda   >WAPTPtr+2               ; get WAPT ptr on stack
0583 00DC 48                    pha   
0584 00DD AF C8 03 E1           lda   >WAPTPtr
0585 00E1 48                    pha   
0586 00E2 3B                    tsc                            ; turn stack to d-page.
0587 00E3 0B                    phd   
0588 00E4 5B                    tcd   
0589 00E5
0590 00E5
0591 00E5              UserENTRY         
0592 00E5              ;----------------------------------------------
0593 00E5              ;
0594 00E5              ;    Now Check Tool Set Number (still in x)
0595 00E5              ;
0596 00E5              ;    To get the WAP info and Function info from the
0597 00E5              ;    memory we change the stack into zero page
0598 00E5              ;
0599 00E5
0600 00E5 8A                    txa   
0601 00E6 48                    pha                            ; save on stack for later
0602 00E7 29 FF 00              and   #$00FF
0603 00EA F0 3A                 beq   BadToolNumber
0604 00EC C7 05                 cmp   [TPTRef]
0605 00EE B0 36                 bcs   BadToolNumber
0606 00F0
0607 00F0              ;----------------------------------------------------
0608 00F0              ;
0609 00F0              ;    Tool number is good.
0610 00F0              ;
0611 00F0 0A                    asl   a
0612 00F1 0A                    asl   a
0613 00F2
0614 00F2 A8                    tay   
0615 00F3
0616 00F3
0617 00F3 B7 01                 lda   [WAPTRef],y              ; get entry in WAPT for tool
0618 00F5 AA                    tax   
0619 00F6 C8                    iny   
0620 00F7 C8                    iny   
0621 00F8 B7 01                 lda   [WAPTRef],y
0622 00FA 85 03                 sta   WAPTRef+2
0623 00FC 86 01                 stx   WAPTRef
0624 00FE
0625 00FE
0626 00FE 88                    dey                            ; back y down 1
0627 00FF B7 05                 lda   [TPTRef],y               ; now get pointer to Tool's FPT
0628 0101 AA                    tax   
0629 0102 88                    dey   
0630 0103 B7 05                 lda   [TPTRef],y
0631 0105 85 05                 sta   TPTRef
0632 0107 86 06                 stx   TPTRef+1
0633 0109
0634 0109              ;-------------------------------------------------
0635 0109              ;
0636 0109              ;   Now we get the adr of the function out
0637 0109              ;   of the table
0638 0109              ;
0639 0109
0640 0109
0641 0109 A3 02                 lda   2,s                      ; now get func num in low byte of a
0642 010B 29 FF 00              and   #$00FF                   ; mask off high byte
0643 010E F0 1B                 beq   BadFunctionNumber
0644 0110 C7 05                 cmp   [FTableRef]
0645 0112 B0 17                 bcs   BadFunctionNumber
0646 0114
0647 0114 0A                    asl   a
0648 0115 0A                    asl   a
0649 0116 A8                    tay   
0650 0117
0651 0117 B7 05                 lda   [FTableRef],y
0652 0119 AA                    tax   
0653 011A C8                    iny   
0654 011B B7 05                 lda   [FTableRef],y
0655 011D
0656 011D 85 06                 sta   FTableRef+1
0657 011F 86 05                 stx   FTableRef
0658 0121
0659 0121              ;--------------------------------------------------
0660 0121              ;
0661 0121              ; Now if everything went right, we pull things off
0662 0121              ; the stack that we need for the function.
0663 0121              ;
0664 0121              ;     DirectReg   2 bytes
0665 0121              ;     WAP         4 bytes  first two in A last 2 in Y
0666 0121              ;     FuncAdr     3 bytes
0667 0121              ;
0668 0121
0669 0121 FA                    plx                            ; put func,tool num in x for rich
0670 0122 2B                    pld                            ; restore direct register
0671 0123 68                    pla                            ; WAP (low word)
0672 0124 7A                    ply                            ; WAP (high word)
0673 0125
0674 0125
0675 0125 6B                    rtl                            ; go to function!
0676 0126
0677 0126              BadToolNumber                           ; 
0678 0126 A2 01 00              ldx   #BadTSNum
0679 0129 80 03                 bra   GoHome
0680 012B
0681 012B              BadFunctionNumber                       ; 
0682 012B A2 02 00              ldx   #BadFuncNum
0683 012E
0684 012E 68           GoHome   pla                            ; get TSNum & FuncNum off stack
0685 012F
0686 012F 2B                    pld                            ; restore d
0687 0130
0688 0130 3B                    tsc                            ; clean off crap from stack
0689 0131 18                    clc   
0690 0132 69 0A 00              adc   #WorkSpace
0691 0135 1B                    tcs   
0692 0136
0693 0136 8A                    txa   
0694 0137 38                    sec                            ; set carry
0695 0138
0696 0138              AnRTL                                   ; 
0697 0138 6B                    rtl   
0698 0139
0699 0139
0700 0139                       ENDP 
0701 0139
0702 0139
0703 0139
0704 0139
0705 0139                       title ' Tables'
0706 0139              ****************************************************************
0707 0139              *
0708 0139              ROM_TPT  PROC  
0709 0139              *
0710 0139              * The ROM tool pointer table is the table which contains
0711 0139              * pointers to all the individual function pointer tables
0712 0139              * (FPT's).
0713 0139              *
0714 0139              * The first entry is a count.  It equals the number of tools
0715 0139              * plus one.
0716 0139              *
0717 0139              *
0718 0139              * Inputs:
0719 0139              *	none
0720 0139              *
0721 0139              * Outputs:
0722 0139              *	none
0723 0139              *
0724 0139              * External Refs:
0725 0139                       import TLTable 
0726 0139                       import MMCallTable 
0727 0139                       import MTCallTable 
0728 0139                       import CallTable 
0729 0139                       import DACallTable 
0730 0139                       import EMCallTable 
0731 0139                       import SchedulerCallTable 
0732 0139                       import SoundCallTable 
0733 0139                       import SKIFNCTBL 
0734 0139                       import SaneCallTable 
0735 0139                       import IMCallTable 
0736 0139                       import TextCallTable 
0737 0139                       import RDCallTable 
0738 0139                       import DummyTable 
0739 0139                       import LECallTable 
0740 0139                       import DialogCallTable  
0741 0139                       import ScrapCallTable 
0742 0139                       import FMCallTable 
0743 0139
0744 0139                       import WindowCallTable 
0745 0139                       import MenuCallTable 
0746 0139                       import ListCallTable 
0747 0139                       import ControlCallTable 
0748 0139
0749 0139              *
0750 0139              * Entry Points:
0751 0139              *	none
0752 0139              *
0753 0139                       longa on                       ; mode
0754 0139                       longi on
0755 0139              *
0756 0139              ****************************************************************
0757 0139
0758 0139 31 00 00 00           DC L:(TheEnd-ROM_TPT)/4        ; number of active tools + 1
0759 013D FD 01 FE 00           DC L:TLTable                   	; 1 Tool Locator
0760 0141 00 00 FC 00           DC L:MMCallTable               	; 2 Memory Manager
0761 0145 BD A5 FE 00           DC L:MTCallTable               	; 3 misc tools
0762 0149 EB FA FC 00           DC L:CallTable                 	; 4 Graphics Core
0763 014D 7B C5 FE 00           DC L:DACallTable               	; 5 Desk Acc Mgr
0764 0151 CF E1 FE 00           DC L:EMCallTable               	; 6 Event Manager
0765 0155 DF DB FC 00           DC L:SchedulerCallTable        ; 7 SchCallTable
0766 0159 53 CB FC 00           DC L:SoundCallTable            	; 8 SoundTable
0767 015D B2 D6 FC 00           DC L:SKIFNCTBL                 	; 9 FDB tool
0768 0161 E7 1A FC 00           DC L:SaneCallTable             	; 10 (SANE)
0769 0165 43 F0 FE 00           DC L:IMCallTable               	; 11 Integer math
0770 0169 19 BF FE 00           DC L:TextCallTable             	; 12 Text Tools
0771 016D C0 00 FC 00           DC L:RDCallTable               	; 13 Ram DISK
0772 0171 00 00 FD 00           DC L:WindowCallTable           ; 14 Window Manager
0773 0175 4A 55 FD 00           DC L:MenuCallTable             	; 15 Menu Manager
0774 0179 20 90 FD 00           DC L:ControlCallTable          ; 16 Control Manager
0775 017D 65 02 FE 00           DC L:DummyTable                	; 17 Loader (not in rom)
0776 0181 65 02 FE 00           DC L:DummyTable                	; 18 QDAux
0777 0185 65 02 FE 00           DC L:DummyTable                	; 19 Print Manager
0778 0189 65 47 FC 00           DC L:LECallTable               	; 20 LineEdit
0779 018D 56 66 FC 00           DC L:DialogCallTable           ; 21 Dialog Manager
0780 0191 82 93 FC 00           DC L:ScrapCallTable            	; 22 Scrap Manager
0781 0195 65 02 FE 00           DC L:DummyTable                	; 23 Standard File
0782 0199 65 02 FE 00           DC L:DummyTable                	; 24 
0783 019D 65 02 FE 00           DC L:DummyTable                	; 25 Note Synth
0784 01A1 65 02 FE 00           DC L:DummyTable                	; 26 Note Seq
0785 01A5 1E 9E FC 00           DC L:FMCallTable               	; 27 Font Manager
0786 01A9 01 E7 FC 00           DC L:ListCallTable             	; 28 List Manager
0787 01AD 65 02 FE 00           DC L:DummyTable                	; 29 A.C.E.
0788 01B1 65 02 FE 00           DC L:DummyTable                	; 30
0789 01B5 65 02 FE 00           DC L:DummyTable                	; 31
0790 01B9 65 02 FE 00           DC L:DummyTable                	; 32 Midi
0791 01BD 65 02 FE 00           DC L:DummyTable                	; 33
0792 01C1 65 02 FE 00           DC L:DummyTable                	; 34
0793 01C5 65 02 FE 00           DC L:DummyTable                	; 35
0794 01C9 65 02 FE 00           DC L:DummyTable                	; 36
0795 01CD 65 02 FE 00           DC L:DummyTable                	; 37
0796 01D1 65 02 FE 00           DC L:DummyTable                	; 38
0797 01D5 65 02 FE 00           DC L:DummyTable                	; 39
0798 01D9 65 02 FE 00           DC L:DummyTable                	; 40
0799 01DD 65 02 FE 00           DC L:DummyTable                	; 41
0800 01E1 65 02 FE 00           DC L:DummyTable                	; 42
0801 01E5 65 02 FE 00           DC L:DummyTable                	; 43
0802 01E9 65 02 FE 00           DC L:DummyTable                	; 44
0803 01ED 65 02 FE 00           DC L:DummyTable                	; 45
0804 01F1 65 02 FE 00           DC L:DummyTable                	; 46
0805 01F5 65 02 FE 00           DC L:DummyTable                	; 47
0806 01F9 65 02 FE 00           DC L:DummyTable                	; 48
0807 01FD
0808 01FD              TheEnd    
0809 01FD
0810 01FD
0811 01FD                       ENDP 
0812 01FD
0813 01FD
0814 01FD                       ENDIF 
0815 01FD
0816 01FD              ****************************************************************
0817 01FD              *
0818 01FD              TLTable  PROC  
0819 01FD              *
0820 01FD              * This is the Function pointer Table (FPT) for the tool
0821 01FD              * locator tool set.
0822 01FD              *
0823 01FD              *
0824 01FD              * Inputs:
0825 01FD              *	none
0826 01FD              *
0827 01FD              * Outputs:
0828 01FD              *	none
0829 01FD              *
0830 01FD              * External Refs:
0831 01FD                       import BootInit 
0832 01FD                       import TLStartUp 
0833 01FD                       import TLShutDown 
0834 01FD                       import TLVersion 
0835 01FD                       import TLReset 
0836 01FD                       import TLStatus 
0837 01FD                       import NotImp 
0838 01FD                       import GetTSPtr 
0839 01FD                       import SetTSPtr 
0840 01FD                       import GetFuncPtr 
0841 01FD                       import GetWAP 
0842 01FD                       import SetWAP 
0843 01FD                       import LoadTools 
0844 01FD                       import LoadOneTool 
0845 01FD                       import UnloadOneTool 
0846 01FD                       import TLMountVolume 
0847 01FD                       import TLTextMountVolume 
0848 01FD                       import SaveTextState 
0849 01FD                       import RestoreTextState 
0850 01FD                       import MessageCenter 
0851 01FD                       import SetDefaultTPT 
0852 01FD                       import MessageByName 
0853 01FD                       import StartupTools 
0854 01FD                       import ShutdownTools 
0855 01FD              *
0856 01FD              * Entry Points:
0857 01FD              *	none
0858 01FD              *
0859 01FD                       longa on                       ; mode
0860 01FD                       longi on
0861 01FD              *
0862 01FD              ****************************************************************
0863 01FD
0864 01FD
0865 01FD 1A 00 00 00           DC L:(TheEnd-TLTable)/4        ; call count + 1
0866 0201 6C 02 FE 00           DC L:BootInit-1                ; 1
0867 0205
0868 0205 44 03 FE 00           DC L:TLStartUp-1               ; 2 app calls for init
0869 0209 41 03 FE 00           DC L:TLShutDown-1              ; 3 app calls to stop
0870 020D
0871 020D 35 04 FE 00           DC L:TLVersion-1               ; 4 version call
0872 0211 D3 03 FE 00           DC L:TLReset-1                 ; 5 reset call
0873 0215 30 04 FE 00           DC L:TLStatus-1                ; 6 status call
0874 0219 D8 FB FE 00           DC L:NotImp-1                  ; 7
0875 021D D8 FB FE 00           DC L:NotImp-1                  ; 8
0876 0221 3D 04 FE 00           DC L:GetTSPtr-1                ; 9
0877 0225 72 04 FE 00           DC L:SetTSPtr-1                ; 10
0878 0229 AA 06 FE 00           DC L:GetFuncPtr-1              ; 11
0879 022D 0F 07 FE 00           DC L:GetWAP-1                  ; 12
0880 0231 44 07 FE 00           DC L:SetWAP-1                  ; 13
0881 0235
0882 0235 2F 08 FE 00           DC L:LoadTools-1               ; (14)
0883 0239 8E 08 FE 00           DC L:LoadOneTool-1             ; (15)
0884 023D AB 08 FE 00           DC L:UnloadOneTool-1           ; (16)
0885 0241 4D CC FD 00           DC L:TLMountVolume-1           ; (17)
0886 0245 C0 D0 FD 00           DC L:TLTextMountVolume-1       ; (18)
0887 0249 D5 C8 FD 00           DC L:SaveTextState-1           ; (19)
0888 024D 4B CA FD 00           DC L:RestoreTextState-1        ; (20);
0889 0251 3D C1 FD 00           DC L:MessageCenter-1           ; (21);
0890 0255 C4 08 FE 00           DC L:SetDefaultTPT-1           ; (22);
0891 0259 B4 BF FD 00           DC L:MessageByName-1           ; (23)  added 23 Oct 88
0892 025D D6 C2 FD 00           DC L:StartupTools-1            ; (24)  added 08 nov 88
0893 0261 01 C5 FD 00           DC L:ShutdownTools-1           ; (25)  added 08 nov 88
0894 0265
0895 0265              TheEnd                                  ; 
0896 0265
0897 0265                       ENDP 
0898 0265
0899 0265
0900 0265              ****************************************************************
0901 0265              *
0902 0265              DummyTable PROC EXPORT 
0903 0265              *
0904 0265              * This is a dummy call table with no pointers in it and a
0905 0265              * count of zero.
0906 0265              *
0907 0265              *
0908 0265              * Inputs:
0909 0265              *	none
0910 0265              *
0911 0265              * Outputs:
0912 0265              *	none
0913 0265              *
0914 0265              * External Refs:
0915 0265              *	none
0916 0265              *
0917 0265              * Entry Points:
0918 0265              *	none
0919 0265              *
0920 0265                       longa on                       ; mode
0921 0265                       longi on
0922 0265              *
0923 0265              ****************************************************************
0924 0265
0925 0265 00 00 00 00           DC L:0
0926 0269
0927 0269                       ENDP 
0928 0269
0929 0269
0930 0269              ****************************************************************
0931 0269              *
0932 0269              UserDummyTable PROC EXPORT 
0933 0269              *
0934 0269              * This is a dummy user TPT with a length of 0 + 1 meaning no
0935 0269              * tools in it.
0936 0269              *
0937 0269              *
0938 0269              * Inputs:
0939 0269              *	none
0940 0269              *
0941 0269              * Outputs:
0942 0269              *	none
0943 0269              *
0944 0269              * External Refs:
0945 0269              *	none
0946 0269              *
0947 0269              * Entry Points:
0948 0269              *	none
0949 0269              *
0950 0269                       longa on                       ; mode
0951 0269                       longi on
0952 0269              *
0953 0269              ****************************************************************
0954 0269
0955 0269
0956 0269 01 00 00 00           DC L:1
0957 026D
0958 026D                       ENDP 
0959 026D
0960 026D
0961 026D
0962 026D
0963 026D
0964 026D
0965 026D                       title ' TLBootInit'
0966 026D              ****************************************************************
0967 026D              *
0968 026D              BootInit PROC 
0969 026D              *
0970 026D              * The boot init code must do the following:
0971 026D              *
0972 026D              *     Initialize the memory manager
0973 026D              *     Find out how many tool sets there are in ROM
0974 026D              *     Allocate enough space for the WAP table for these tools
0975 026D              *     Set the pointers in the WAP table to zero
0976 026D              *     Call the boot initialization function of each of the
0977 026D              *        other (besides tool locator and mm) tool sets in ROM.
0978 026D              *
0979 026D              * Calling Sequence
0980 026D              *
0981 026D              *     ldx #thenumbers
0982 026D              *     jsl Dispatch
0983 026D              *
0984 026D              *
0985 026D              * Inputs:
0986 026D              *	none
0987 026D              *
0988 026D              * Outputs:
0989 026D              *	none
0990 026D              *
0991 026D              * External Refs:
0992 026D                       import TLNewHandle 
0993 026D                       import SetUpUserWAPT 
0994 026D              *
0995 026D              * Entry Points:
0996 026D              *	none
0997 026D              *
0998 026D                       longa on                       ; mode
0999 026D                       longi on
1000 026D              *
1001 026D              * Modification History
1002 026D              *
1003 026D              * 05 Dec 86    SEG	    Changed Push #0 to pha, where all I needed
1004 026D              *	    was space for result.  Removed jsr to
1005 026D              *	    ResetUserPtrs since they do not need to
1006 026D              *	    be reset when they have not yet been changed.
1007 026D              *
1008 026D              * 17 Jun 88	Steven Glass
1009 026D              *
1010 026D              * Changed use of TLNewHandle for new reg usage.
1011 026D              *
1012 026D              ****************************************************************
1013 026D
1014 026D              TPTRef   equ   1
1015 026D              WAPTRef  equ   TPTRef+4
1016 026D
1017 026D              ZPSize   equ   WAPTRef+4
1018 026D
1019 026D              RTL1     equ   ZPSize
1020 026D              RTL2     equ   RTL1+3
1021 026D
1022 026D              ParamSize equ   0
1023 026D
1024 026D              ;----------------------------------------
1025 026D              ;
1026 026D              ; Get some space off the stack.
1027 026D              ;
1028 026D
1029 026D 3B                    tsc                            ; get stack pointer
1030 026E 38                    sec                            ; subtract zpsize
1031 026F E9 08 00              sbc   #ZPSize-1
1032 0272 1B                    tcs                            ; put back
1033 0273 0B                    phd                            ; save d
1034 0274 5B                    tcd                            ; make stack zp
1035 0275
1036 0275              ;----------------------------------------
1037 0275              ;
1038 0275              ; Initialize the memory manager.
1039 0275              ;
1040 0275
1041 0275 A2 02 01              ldx   #$0102
1042 0278 22 00 00 E1           jsl   $E10000                  ; initialize the memory manager
1043 027C 90 03                 bcc   cont1
1044 027E 4C ED 02              jmp   Die
1045 0281
1046 0281              cont1                                   ; 
1047 0281 22 80 16 E1           jsl   MMWarmStart1             ; call mm mgr warm start vector
1048 0285
1049 0285              ;----------------------------------------
1050 0285              ;
1051 0285              ; use the number of Tool Sets in ROM
1052 0285              ; to calculate how much space to
1053 0285              ; reserve for the WAPT.
1054 0285              ;
1055 0285 AF C0 03 E1           lda   >TPTPtr                  ; look at the count in the TPT
1056 0289 85 01                 sta   TPTRef
1057 028B AF C2 03 E1           lda   >TPTPtr+2
1058 028F 85 03                 sta   TPTRef+2
1059 0291
1060 0291 A7 01                 lda   [TPTRef]
1061 0293
1062 0293 0A                    asl   a                        ; multiply by four
1063 0294 0A                    asl   a
1064 0295
1065 0295
1066 0295              * Get enough memory to store the number of bytes in a
1067 0295 20 A8 07              jsr   TLNewHandle
1068 0298 90 03                 bcc   cont2
1069 029A 82 50 00              brl   Die
1070 029D
1071 029D 85 05        cont2    sta   WAPTRef                  ; put handle on zp
1072 029F 86 07                 stx   WaptRef+2
1073 02A1 A7 05                 lda   [WAPTRef]                ; and dereference it
1074 02A3 AA                    tax   
1075 02A4 A0 02 00              ldy   #2
1076 02A7 B7 05                 lda   [WaptRef],y
1077 02A9 85 07                 sta   WAPTRef+2                ; store pointer on zp and in
1078 02AB 8F CA 03 E1           sta   >WAPTPtr+2               ; permanent loc
1079 02AF 86 05                 stx   WAPTRef
1080 02B1 8A                    txa   
1081 02B2 8F C8 03 E1           sta   >WAPTPtr
1082 02B6
1083 02B6              ;----------------------------------------
1084 02B6              ;
1085 02B6              ; Zero the new WAPT.
1086 02B6              ;
1087 02B6
1088 02B6 A7 01                 lda   [TPTRef]
1089 02B8 0A                    asl   a
1090 02B9 0A                    asl   a
1091 02BA A8                    tay   
1092 02BB 88                    dey                            ; subtract 2
1093 02BC 88                    dey   
1094 02BD A9 00 00              lda   #0                       ; zero the memory
1095 02C0 97 05        ZeroLoop sta   [WAPTRef],y
1096 02C2 88                    dey   
1097 02C3 88                    dey   
1098 02C4 10 FA                 bpl   ZeroLoop
1099 02C6
1100 02C6
1101 02C6              ;----------------------------------------------------
1102 02C6              ;
1103 02C6              ; The system WAPT is set up and zeroed.
1104 02C6              ; Now I must set up the user WAPT.
1105 02C6              ;
1106 02C6
1107 02C6 20 12 03              jsr   SetUpUserWAPT
1108 02C9 B0 22                 bcs   die
1109 02CB
1110 02CB
1111 02CB              ;---------------------------------------
1112 02CB              ;
1113 02CB              ; The WAPT is set up and zeroed.  The
1114 02CB              ; individual tools can now be initialized
1115 02CB              ; starting with number 3.
1116 02CB
1117 02CB F4 03 01              pea   $0103                    ; put this call number on the stack
1118 02CE A3 01        InitLoop lda   1,s                      ; get the current call number
1119 02D0 AA                    tax                            ; put it on the stack
1120 02D1 22 00 00 E1           jsl   $E10000                  ; make call
1121 02D5 B0 07                 bcs   CheckError               ; check error code
1122 02D7 A3 01        KeepGoing lda   1,s                     ; get call number back
1123 02D9 1A                    inc   a                        ; increment the tool number part
1124 02DA 83 01                 sta   1,s                      ; put it back on stack
1125 02DC 80 F0                 bra   InitLoop                 ; do it again
1126 02DE
1127 02DE C9 02 00     CheckError cmp   #BadFuncNum            ; bad func number but ts is there
1128 02E1 F0 F4                 beq   KeepGoing                ; so go to next
1129 02E3
1130 02E3 A2 00 00              ldx   #0                       ; assume no error
1131 02E6 C9 01 00              cmp   #BadTSNum                ; if error passed back is BadTSNum
1132 02E9 F0 01                 beq   NoError                  ; then there was no error
1133 02EB
1134 02EB AA                    tax                            ; return this error code
1135 02EC 68           NoError  pla                            ; clean stack
1136 02ED
1137 02ED              Die                                     ; 
1138 02ED 2B                    pld                            ; restore zero page
1139 02EE 3B                    tsc                            ; fix stack
1140 02EF 18                    clc   
1141 02F0 69 08 00              adc   #ZPSize+ParamSize-1
1142 02F3 1B                    tcs   
1143 02F4
1144 02F4 8A                    txa                            ; put error code back in a
1145 02F5 C9 01 00              cmp   #1                       ; compare to one to fix carry
1146 02F8 B0 17                 bcs   NeverMind
1147 02FA
1148 02FA 22 84 16 E1           jsl   MMWarmStart2             ; cannot return error
1149 02FE
1150 02FE
1151 02FE
1152 02FE              ;---------------------------------------------------
1153 02FE              ;
1154 02FE              ; Zero the pointer to the default TPT and call
1155 02FE              ; set DefaultTPT.
1156 02FE              ;
1157 02FE A9 00 00              lda   #0
1158 0301 8F 88 01 E1           sta   >DefaultTPTPtr
1159 0305 8F 8A 01 E1           sta   >DefaultTPTPtr+2
1160 0309
1161 0309 A2 01 16 22           _SetDefaultTPT 
1162 0310
1163 0310
1164 0310 18                    clc   
1165 0311 6B           NeverMind rtl   
1166 0312
1167 0312
1168 0312                       ENDP 
1169 0312
1170 0312                       title 'SetUpUserWAPT'
1171 0312              ****************************************************************
1172 0312              *
1173 0312              SetUpUserWAPT PROC 
1174 0312              *
1175 0312              * Routine to set up the UserWAPT pointer.  This routine gets a
1176 0312              * handle for four bytes and puts the dereferenced pointer in
1177 0312              * U_WAPTPtr.
1178 0312              *
1179 0312              * It also zeros the four bytes that are obtained.
1180 0312              *
1181 0312              *
1182 0312              * Inputs:
1183 0312              *	none
1184 0312              *
1185 0312              * Outputs:
1186 0312              *	none
1187 0312              *
1188 0312              * External Refs:
1189 0312                       import TLNewHandle 
1190 0312              *
1191 0312              * Entry Points:
1192 0312              *	none
1193 0312              *
1194 0312                       longa on                       ; mode
1195 0312                       longi on
1196 0312              *
1197 0312              * 17 Jun 88	Steven Glass
1198 0312              *
1199 0312              * Changed use of TLNewHandle for new reg usage.
1200 0312              *
1201 0312              ****************************************************************
1202 0312
1203 0312
1204 0312 A9 04 00              lda   #4
1205 0315 20 A8 07              jsr   TLNewHandle
1206 0318 B0 27                 bcs   done
1207 031A
1208 031A DA                    phx                            ; put handle back on stack
1209 031B 48                    pha   
1210 031C 0B                    phd   
1211 031D 3B                    tsc   
1212 031E 5B                    tcd   
1213 031F
1214 031F              Handle   equ   3
1215 031F
1216 031F A7 03                 lda   [Handle]                 ; and dereference it
1217 0321 AA                    tax   
1218 0322 A0 02 00              ldy   #2
1219 0325 B7 03                 lda   [Handle],y
1220 0327 85 05                 sta   Handle+2
1221 0329 8F CE 03 E1           sta   >U_WAPTPtr+2             ; and put in permanent loc
1222 032D 86 03                 stx   Handle
1223 032F 8A                    txa   
1224 0330 8F CC 03 E1           sta   >U_WAPTPtr
1225 0334
1226 0334 A9 00 00              lda   #0                       ; zero it
1227 0337 87 03                 sta   [Handle]
1228 0339 A0 02 00              ldy   #2
1229 033C 97 03                 sta   [Handle],y
1230 033E
1231 033E 2B                    pld                            ; restore d
1232 033F 68                    pla                            ; clear stack
1233 0340 68                    pla   
1234 0341
1235 0341 60           Done     rts                            ; carry is already clear.
1236 0342
1237 0342                       ENDP 
1238 0342
1239 0342                       title 'TLStartAndStop'
1240 0342              ****************************************************************
1241 0342              *
1242 0342              TLStartAndStop PROC EXPORT 
1243 0342              *
1244 0342              * All this does is to clear out the User Tool Pointers.
1245 0342              *
1246 0342              *
1247 0342              * Inputs:
1248 0342              *	none
1249 0342              *
1250 0342              * Outputs:
1251 0342              *	none
1252 0342              *
1253 0342              * External Refs:
1254 0342                       import UnloadTools 
1255 0342                       import ResetUserPtrs 
1256 0342              *
1257 0342              * Entry Points:
1258 0342                       EXPORT TLShutDown 
1259 0342                       EXPORT TLStartup 
1260 0342              *
1261 0342                       longa on                       ; mode
1262 0342                       longi on
1263 0342              *
1264 0342              * Change History
1265 0342              *
1266 0342              * 04 Nov 88	Steven Glass
1267 0342              *
1268 0342              * Reset user pointer is now incorporated into this code.TLStartup
1269 0342              * is also public so can be linked to patch file.
1270 0342              *
1271 0342              ****************************************************************
1272 0342
1273 0342              TLShutDown  
1274 0342 20 B5 0A              jsr   UnloadTools
1275 0345
1276 0345
1277 0345              TLStartUp  
1278 0345
1279 0345              ;-----------------------------------------------------------
1280 0345              ;
1281 0345              ; Reset User Pointer is now inline.  It is not called from
1282 0345              ; anywhere else.
1283 0345              ;
1284 0345
1285 0345 AF C4 03 E1           lda   >U_TPTPtr
1286 0349 C9 69 02              cmp   #UserDummyTable
1287 034C D0 09                 bne   DumpHandle
1288 034E AF C6 03 E1           lda   >U_TPTPtr+2
1289 0352 C9 FE 00              cmp   #^UserDummyTable
1290 0355 F0 7A                 beq   NothingToReset
1291 0357
1292 0357 48           DumpHandle pha                          ; space for result
1293 0358 48                    pha   
1294 0359 AF C6 03 E1           lda   >U_TPTPtr+2
1295 035D 29 FF 00              and   #$00FF                   ; just in case the high word is trash.
1296 0360 48                    pha   
1297 0361 AF C4 03 E1           lda   >U_TPTPtr
1298 0365 48                    pha   
1299 0366 A2 02 1A 22           _FindHandle                    ; note:  I do not check for errors
1300 036D A2 02 10 22           _DisposeHandle                 ; here because they are very unlikely
1301 0374              *		; moveover, If the handle cannot
1302 0374              *		; be found, FindHandle returns
1303 0374              *		; NIL and DisposeHandle won't dispose
1304 0374              *		; anything when passed a NIL
1305 0374
1306 0374              ResetIt                                 ; 
1307 0374 A9 69 02              lda   #UserDummyTable
1308 0377 8F C4 03 E1           sta   >U_TPTPtr
1309 037B A9 FE 00              lda   #^UserDummyTable
1310 037E 8F C6 03 E1           sta   >U_TPTPtr+2
1311 0382
1312 0382 48                    pha                            ; space for result
1313 0383 48                    pha   
1314 0384 AF CE 03 E1           lda   >U_WAPTPtr+2
1315 0388 29 FF 00              and   #$00FF
1316 038B 48                    pha   
1317 038C AF CC 03 E1           lda   >U_WAPTPtr
1318 0390 48                    pha   
1319 0391 A2 02 1A 22           _FindHandle                    ; again I do not check for an error
1320 0398              *			; here for the same reasons as above
1321 0398
1322 0398 0B                    phd                            ; save d
1323 0399 3B                    tsc                            ; and make stack into direct page
1324 039A 5B                    tcd   
1325 039B
1326 039B              TheD     equ   1
1327 039B              TheHandle equ   3
1328 039B A0 04 00              ldy   #4                       ; unlock the orig handle
1329 039E B7 03                 lda   [TheHandle],y
1330 03A0 29 FF 7F              and   #$7FFF
1331 03A3 97 03                 sta   [TheHandle],y
1332 03A5
1333 03A5 F4 00 00 F4           PushLong #4                    ; resize the handle
1334 03AB D4 05                 pei   TheHandle+2
1335 03AD D4 03                 pei   TheHandle
1336 03AF A2 02 19 22           _SetHandleSize 
1337 03B6
1338 03B6 A0 04 00              ldy   #4                       ; lock the handle and deref it
1339 03B9 B7 03                 lda   [TheHandle],y            ; putting result back in
1340 03BB 09 00 80              ora   #$8000                   ; U_WAPTPtr
1341 03BE 97 03                 sta   [TheHandle],y
1342 03C0 A7 03                 lda   [TheHandle]
1343 03C2 8F CC 03 E1           sta   >U_WAPTPtr
1344 03C6 88                    dey   
1345 03C7 88                    dey   
1346 03C8 B7 03                 lda   [TheHandle],y
1347 03CA 8F CE 03 E1           sta   >U_WAPTPtr+2
1348 03CE
1349 03CE 2B                    pld                            ; restore direct
1350 03CF 68                    pla                            ; clear handle of stack
1351 03D0 68                    pla   
1352 03D1
1353 03D1              NothingToReset  
1354 03D1 4C DF FB              jmp   oEndCall0
1355 03D4
1356 03D4                       ENDP 
1357 03D4
1358 03D4
1359 03D4                       title 'TLReset'
1360 03D4              ****************************************************************
1361 03D4              *
1362 03D4              TLReset  PROC 
1363 03D4              *
1364 03D4              * Resets the user pointers and calls the reset function 
1365 03D4              * for every tool set.  If any of the tools returns an error, 
1366 03D4              * this routine calls SystemDeath. If no tools return an error, 
1367 03D4              * then this routine returns with no error.
1368 03D4              *
1369 03D4              * Inputs:
1370 03D4              *	none
1371 03D4              *
1372 03D4              * Outputs:
1373 03D4              *	none
1374 03D4              *
1375 03D4              * External Refs:
1376 03D4              *	none
1377 03D4              *
1378 03D4              * Entry Points:
1379 03D4              *	none
1380 03D4              *
1381 03D4                       longa on                       ; mode
1382 03D4                       longi on
1383 03D4              *
1384 03D4              ****************************************************************
1385 03D4
1386 03D4
1387 03D4
1388 03D4 A2 02 05              ldx   #$0502                   ; start by reseting the memmgr
1389 03D7 22 00 00 E1           jsl   $E10000                  ; this cannot fail?
1390 03DB
1391 03DB F4 00 00              pea   0                        ; put this flag on the stack
1392 03DE
1393 03DE F4 03 05              pea   $0503                    ; the reset call is 5, start w/ts #3
1394 03E1 A3 01        ResetLoop lda   1,s
1395 03E3 AA                    tax   
1396 03E4 22 00 00 E1           jsl   $E10000
1397 03E8 B0 07                 bcs   CheckError
1398 03EA A3 01        KeepGoing lda   1,s
1399 03EC 1A                    inc   a
1400 03ED 83 01                 sta   1,s
1401 03EF 80 F0                 bra   ResetLoop
1402 03F1
1403 03F1 C9 01 00     CheckError cmp   #BadTSNum              ; if the error is BadTSNum then we are
1404 03F4 F0 09                 beq   AllDone                  ; done, otherwise we die later so save
1405 03F6              *			; error code and keepgoing
1406 03F6
1407 03F6 C9 02 00              cmp   #BadFuncNum              ; if the error is bad func num
1408 03F9 F0 EF                 beq   KeepGoing                ; then just a dummy table
1409 03FB
1410 03FB 83 03                 sta   3,s                      ; otherwise all is not kosher so
1411 03FD 80 EB                 bra   KeepGoing                ; trash my indicator and continue.
1412 03FF
1413 03FF              AllDone                                 ; 
1414 03FF 68                    pla                            ; bad ts number so clean stack
1415 0400 68                    pla   
1416 0401 D0 0A                 bne   Die
1417 0403
1418 0403 A2 01 03 22           _TLShutdown 
1419 040A 4C DF FB              jmp   oEndCall0
1420 040D
1421 040D 48           Die      pha                            ; put death info on stack
1422 040E F4 FE 00 F4           PushLong #DeathString 
1423 0414
1424 0414
1425 0414 A2 01 01              ldx   #$0101                   ; re-init all the tools
1426 0417 22 00 00 E1           jsl   $E10000
1427 041B
1428 041B A2 03 15 22           _SysFailMgr                    ; now die
1429 0422
1430 0422
1431 0422 0E 43 61 6E  DeathString DC C:'Cannot Reset $'
1432 0431
1433 0431                       ENDP 
1434 0431
1435 0431                       title 'TLStatus and TLVersion'
1436 0431              ****************************************************************
1437 0431              *
1438 0431              TLSTATUS PROC 
1439 0431              *
1440 0431              * Returns true all the time since the TL is always active!
1441 0431              *
1442 0431              *
1443 0431              * Inputs:
1444 0431              *	none
1445 0431              *
1446 0431              * Outputs:
1447 0431              *	StatusFlag : Boolean
1448 0431              *
1449 0431              * External Refs:
1450 0431                       import JoinVersion 
1451 0431              *
1452 0431              * Entry Points:
1453 0431              *	none
1454 0431              *
1455 0431                       longa on                       ; mode
1456 0431                       longi on
1457 0431              *
1458 0431              *
1459 0431              * Modification History
1460 0431              *
1461 0431              * 05 Dec 86    SEG	    Put result at right place on stack
1462 0431              *
1463 0431              * 24 Oct 88    SEG      This now shares code with TLVersion.
1464 0431              *
1465 0431              ****************************************************************
1466 0431
1467 0431
1468 0431 A9 FF FF              lda   #True
1469 0434 80 03                 bra   JoinVersion
1470 0436
1471 0436
1472 0436
1473 0436
1474 0436                       ENDP 
1475 0436
1476 0436
1477 0436              ****************************************************************
1478 0436              *
1479 0436              TLVersion PROC EXPORT 
1480 0436              *
1481 0436              * Returns the version number of the tool locator.
1482 0436              *
1483 0436              *
1484 0436              * Inputs:
1485 0436              *	none
1486 0436              *
1487 0436              * Outputs:
1488 0436              *	VersionNum : Word
1489 0436              *
1490 0436              * External Refs:
1491 0436              *	none
1492 0436              *
1493 0436              * Entry Points:
1494 0436                       entry JoinVersion 
1495 0436              *	
1496 0436              *
1497 0436                       longa on                       ; mode
1498 0436                       longi on
1499 0436              *
1500 0436              *
1501 0436              * Modification History
1502 0436              *
1503 0436              * 05 Dec 86    SEG	    Shares code with TLStatus (saving
1504 0436              *	    3 bytes)
1505 0436              *
1506 0436              * 24 Oct 88    SEG      This is now self contained so that it
1507 0436              *	    can link by itself.  TLStatus shares
1508 0436              *	    code with this instead of the otherway
1509 0436              *	    around.
1510 0436              *
1511 0436              ****************************************************************
1512 0436
1513 0436
1514 0436 A9 00 03              lda   #TLVersionNumber
1515 0439
1516 0439
1517 0439              JoinVersion         
1518 0439 83 07                 sta   7,s
1519 043B 4C DF FB              jmp   oEndCall0
1520 043E
1521 043E                       ENDP 
1522 043E
1523 043E
1524 043E
1525 043E
1526 043E                       title 'GetTSPtr'
1527 043E              ****************************************************************
1528 043E              *
1529 043E              GetTSPtr PROC 
1530 043E              *
1531 043E              * Returns the pointer to a Function Pointer Table in the
1532 043E              * Tool Pointer Table.
1533 043E              *
1534 043E              * Calling Sequence
1535 043E              *
1536 043E              *        pha		; make room
1537 043E              *        pha
1538 043E              *        PushWord UserOrSystem
1539 043E              *        PushWord TSNum
1540 043E              *        _GetTSPtr
1541 043E              *
1542 043E              *
1543 043E              * Inputs:
1544 043E              *	UserOrSystemFlag : word
1545 043E              *	ToolNumber : word
1546 043E              *
1547 043E              * Outputs:
1548 043E              *	ToolPointer : long
1549 043E              *
1550 043E              * External Refs:
1551 043E              *	none
1552 043E              *
1553 043E              * Entry Points:
1554 043E              *	none
1555 043E              *
1556 043E                       longa on                       ; mode
1557 043E                       longi on
1558 043E              *
1559 043E              *
1560 043E              * Change History
1561 043E              *
1562 043E              * 23 Jan 86	SEG
1563 043E              *
1564 043E              *     Should work now and is now written in more common style.
1565 043E              *
1566 043E              ****************************************************************
1567 043E
1568 043E
1569 043E              OrigDirect equ   1
1570 043E              RTL1     equ   OrigDirect+2
1571 043E              RTL2     equ   RTL1+3
1572 043E              TSNum    equ   RTL2+3
1573 043E              UserOrSystem equ   TSNum+2
1574 043E              FTablePtr equ   UserOrSystem+2
1575 043E
1576 043E              TPTRef   equ   TSNum                    ; overwrite after reading
1577 043E
1578 043E 0B                    phd                            ; save this
1579 043F 3B                    tsc                            ; get stack pointer
1580 0440 5B                    tcd                            ; make stack zp
1581 0441
1582 0441 A6 09                 ldx   TSNum                    ; get his in register
1583 0443
1584 0443 24 0B                 bit   UserOrSystem
1585 0445 30 0C                 bmi   UserPtrs
1586 0447
1587 0447 AF C0 03 E1           lda   >TPTPtr                  ; get the TPTPtr to zero page
1588 044B 85 09                 sta   TPTRef
1589 044D AF C1 03 E1           lda   >TPTPtr+1
1590 0451 80 0A                 bra   GotPtrs
1591 0453
1592 0453 AF C4 03 E1  UserPtrs lda   >U_TPTPtr
1593 0457 85 09                 sta   TPTRef
1594 0459 AF C5 03 E1           lda   >U_TPTPtr+1
1595 045D
1596 045D 85 0A        GotPtrs  sta   TPTRef+1
1597 045F
1598 045F
1599 045F 8A                    txa   
1600 0460 29 FF 00              and   #$00FF
1601 0463 0A                    asl   a
1602 0464 0A                    asl   a
1603 0465 A8                    tay   
1604 0466
1605 0466 B7 09                 lda   [TPTRef],y
1606 0468 85 0D                 sta   FTablePtr
1607 046A C8                    iny   
1608 046B C8                    iny   
1609 046C B7 09                 lda   [TPTRef],y
1610 046E 85 0F                 sta   FTablePtr+2
1611 0470
1612 0470 4C 0E FC              jmp   EndCall4
1613 0473
1614 0473
1615 0473                       ENDP 
1616 0473
1617 0473                       title 'SetTSPtr'
1618 0473              ****************************************************************
1619 0473              *
1620 0473              SetTSPtr PROC Export 
1621 0473              *
1622 0473              * Installs the pointer to a Function Pointer Table in the
1623 0473              * Tool Pointer Table.
1624 0473              *
1625 0473              * If the Tool Pointer Table is not in RAM, it
1626 0473              * copies the table into RAM.
1627 0473              *
1628 0473              * If there is not enough room in the TPT for the new entry,
1629 0473              * the TPT is moved to a bigger chunk of memory.  Likewise the
1630 0473              * WAP Table is expanded.
1631 0473              *
1632 0473              * If the new pointer table has zero entries, old entries are
1633 0473              * moved from prior table to new table.
1634 0473              *
1635 0473              * After the table is installed, the BootInit call of the
1636 0473              * newly installed tool is made.
1637 0473              *
1638 0473              * Possible Errors:
1639 0473              *
1640 0473              *        Not enough memory.
1641 0473              *
1642 0473              *
1643 0473              * Calling Sequence
1644 0473              *
1645 0473              *        PushWord UserOrSystem
1646 0473              *        PushWord FuncNumber
1647 0473              *        PushPtr FuncTable
1648 0473              *        _SetTSPtr
1649 0473              *
1650 0473              *
1651 0473              *
1652 0473              * Inputs:
1653 0473              *        UserOrSystem : integer
1654 0473              *        TSNumber : integer
1655 0473              *        FTablePtr : Ptr
1656 0473              *
1657 0473              * Outputs:
1658 0473              *	none
1659 0473              *
1660 0473              * External Refs:
1661 0473                       import GrowTables 
1662 0473                       import ResetTPTPtr 
1663 0473                       import TLNewHandle 
1664 0473              *
1665 0473              * Entry Points:
1666 0473              *	none
1667 0473              *
1668 0473                       longa on                       ; mode
1669 0473                       longi on
1670 0473              *
1671 0473              *
1672 0473              * Modification History
1673 0473              *
1674 0473              * June 5, 1986   SEG
1675 0473              *
1676 0473              *     Patches were not being installed properly.  On close
1677 0473              *     inspection I discovered that I was Trashing the value
1678 0473              *     of OldTSPtr as I moved it from the TPT Table to zero
1679 0473              *     page.  This meant that whenever I found a zero in the
1680 0473              *     new table, I put garbage there instead of the real
1681 0473              *     previous address.
1682 0473              *
1683 0473              * System Disk 1.1 SEG
1684 0473              *
1685 0473              *     I found that the case where we had to grow the existing
1686 0473              *     table did not work
1687 0473              *
1688 0473              * 04 Dec 86 For ROM 2.0 SEG
1689 0473              *
1690 0473              *     Saved a few bytes here and there turning PushLong #0
1691 0473              *     to pha, pha when all we needed was space for results.
1692 0473              *
1693 0473              * 17 Jun 88	Steven Glass
1694 0473              *
1695 0473              * Changed use of TLNewHandle for new reg usage.
1696 0473              *
1697 0473              * 24 Oct 88	Steven Glass
1698 0473              *
1699 0473              * Changed the way this works for tools 1 and 5.  If the tool number is
1700 0473              * 1 or 5 and it is a system tools, I don't install it.  This prevents
1701 0473              * the tool locator and desk manager patch from system disks 1.0 - 3.1
1702 0473              * from being installed.  It forces the use of the tools in ROM.
1703 0473              *
1704 0473              * To patch tool 1 or 5 we have to set the SysOrUser flag to non
1705 0473              * zero with high bit clear.  Zero will not work.
1706 0473              *
1707 0473              *
1708 0473              * 07 Dec 88	Steven Glass
1709 0473              *
1710 0473              * Changed code that calls bootinit routine so that it never calls
1711 0473              * the memory manager boot init routine in ROM.
1712 0473              *
1713 0473              * 3/2/89	Mensch
1714 0473              * Fixed a bug in detecting if the default table is being pointed at.
1715 0473              * This call should now be able to run out of ROM
1716 0473              *
1717 0473              ****************************************************************
1718 0473
1719 0473
1720 0473              TPTRef   equ   1                        ; this is where I put pointer to
1721 0473              *			; old TPT
1722 0473              OldTSPtr equ   TPTRef+4                 ; this is pointer to old FPT
1723 0473              NewTPTRef equ   OldTSPtr+4              ; this is where I put pointer to
1724 0473              *			; new TPT
1725 0473              WAPTRef  equ   NewTPTRef+4              ; pointer to current WAPT
1726 0473              *
1727 0473              AHandle  equ   WAPTRef+4                ; this is temp storage for any
1728 0473              *			; handle I need to deal with.
1729 0473
1730 0473              ZPSize   equ   AHandle+4
1731 0473
1732 0473              RTL1     equ   ZPSize
1733 0473              RTL2     equ   RTL1+3
1734 0473              FTablePtr equ   RTL2+3
1735 0473              TSNum    equ   FTablePtr+4
1736 0473              UserOrSystem equ   TSNum+2
1737 0473
1738 0473              ParamSize equ   8
1739 0473
1740 0473
1741 0473
1742 0473              ;-----------------------------------------------
1743 0473              ;
1744 0473              ; First get some space for zero page.
1745 0473              ;
1746 0473 3B                    tsc                            ; get stack pointer
1747 0474 38                    sec                            ; subtract zpsize
1748 0475 E9 14 00              sbc   #ZPSize-1
1749 0478 1B                    tcs                            ; put back
1750 0479 0B                    phd                            ; save d
1751 047A 5B                    tcd                            ; make stack zp
1752 047B
1753 047B
1754 047B              ;-----------------------------------------------------------
1755 047B              ;
1756 047B              ; In order to prevent system disks 1.0 through 3.1 from
1757 047B              ; patching out the tool locator and desk manager, we
1758 047B              ; look at the OS_Flag word.  Bit 2 of this word is FPatchLoaded.
1759 047B              ; It is set every time DeskShutdown is called.
1760 047B              ;
1761 047B              ; The first time DeskShutdown is called is right after the setup
1762 047B              ; files are loaded and just before the first application is about
1763 047B              ; to run.
1764 047B              ;
1765 047B              ; We use this bit to tell us whether or not to ignore attemps
1766 047B              ; to patch out the tool locator and desk manager.  Until
1767 047B              ; this bit is set, we will ignore all such attempts.
1768 047B              ;
1769 047B              ;
1770 047B AF BE 00 E1           lda   >OS_Flag
1771 047F 29 04 00              and   #PatchLoadedBit
1772 0482 D0 13                 bne   NoProblem
1773 0484
1774 0484 A5 1F                 lda   TSNum
1775 0486 C9 01 00              cmp   #1
1776 0489 F0 05                 beq   EGads
1777 048B C9 05 00              cmp   #5
1778 048E D0 07                 bne   NoProblem
1779 0490
1780 0490 A5 21        EGads    lda   UserOrSystem
1781 0492 D0 03                 bne   NoProblem
1782 0494
1783 0494 82 F1 00              brl   InitDone
1784 0497
1785 0497              NoProblem  
1786 0497
1787 0497              ;-----------------------------------------------
1788 0497              ;
1789 0497              ; Move the right pointers to zero page depending
1790 0497              ; on whether this is a system or user call.
1791 0497              ;
1792 0497
1793 0497 24 21                 bit   UserOrSystem
1794 0499 30 18                 bmi   UserPtrs
1795 049B
1796 049B AF C0 03 E1           lda   >TPTPtr                  ; get the TPTPtr to zero page
1797 049F 85 01                 sta   TPTRef
1798 04A1 AF C2 03 E1           lda   >TPTPtr+2
1799 04A5 85 03                 sta   TPTRef+2
1800 04A7 AF C8 03 E1           lda   >WAPTPtr
1801 04AB 85 0D                 sta   WAPTRef
1802 04AD AF CA 03 E1           lda   >WAPTPtr+2
1803 04B1 80 16                 bra   GotPtrs
1804 04B3
1805 04B3 AF C4 03 E1  UserPtrs lda   >U_TPTPtr
1806 04B7 85 01                 sta   TPTRef
1807 04B9 AF C6 03 E1           lda   >U_TPTPtr+2
1808 04BD 85 03                 sta   TPTRef+2
1809 04BF AF CC 03 E1           lda   >U_WAPTPtr
1810 04C3 85 0D                 sta   WAPTRef
1811 04C5 AF CE 03 E1           lda   >U_WAPTPtr+2
1812 04C9 85 0F        GotPtrs  sta   WAPTRef+2
1813 04CB
1814 04CB              ;-----------------------------------------------
1815 04CB              ;
1816 04CB              ; check to see if we need to move the TPT
1817 04CB              ;
1818 04CB A5 03                 lda   TPTRef+2
1819 04CD 29 FF 00              and   #$00FF
1820 04D0 C9 FE 00              cmp   #$00FE
1821 04D3 F0 1A                 beq   NeedToMove
1822 04D5
1823 04D5              ;-----------------------------------------------------------
1824 04D5              ;
1825 04D5              ; Added the following for RAM basedc tool locator...
1826 04D5              ;
1827 04D5 A5 01                 lda   TPTRef
1828 04D7 C9 69 02              cmp   #UserDummyTable
1829 04DA D0 09                 bne   NoNeedToMove
1830 04DC A5 03                 lda   TPTRef+2
1831 04DE C9 FE 00              cmp   #^UserDummyTable
1832 04E1 D0 02                 bne   NoNeedToMove
1833 04E3 80 0A                 bra   NeedToMove
1834 04E5
1835 04E5              ;-----------------------------------------------
1836 04E5              ;
1837 04E5              ; It is already in RAM so move the pointer to it
1838 04E5              ; into NewTPTRef
1839 04E5              ;
1840 04E5              NoNeedToMove                            ; 
1841 04E5 A5 01                 lda   TPTRef
1842 04E7 85 09                 sta   NewTPTRef
1843 04E9 A5 03                 lda   TPTRef+2
1844 04EB 85 0B                 sta   NewTPTRef+2
1845 04ED 80 30                 bra   TableInPlace
1846 04EF
1847 04EF              ;-----------------------------------------------
1848 04EF              ;
1849 04EF              ; It is still in ROM so we get space for it in
1850 04EF              ; RAM and copy it over.
1851 04EF              ;
1852 04EF              NeedToMove                              ; 
1853 04EF A7 01                 lda   [TPTRef]                 ; The size I need is
1854 04F1 0A                    asl   a                        ; 4 * count
1855 04F2 0A                    asl   a
1856 04F3
1857 04F3 20 A8 07              jsr   TLNewHandle
1858 04F6 85 11                 sta   AHandle
1859 04F8 86 13                 stx   AHandle+2
1860 04FA
1861 04FA A7 11                 lda   [AHandle]
1862 04FC 85 09                 sta   NewTPTRef
1863 04FE A0 02 00              ldy   #2
1864 0501 B7 11                 lda   [AHandle],y
1865 0503 85 0B                 sta   NewTPTRef+2
1866 0505
1867 0505 D4 03                 pei   TPTRef+2                 ; copy the old to the new
1868 0507 D4 01                 pei   TPTRef
1869 0509 D4 0B                 pei   NewTPTRef+2
1870 050B D4 09                 pei   NewTPTRef
1871 050D A7 01                 lda   [TPTRef]
1872 050F 0A                    asl   a
1873 0510 0A                    asl   a
1874 0511 F4 00 00              PushWord #0 
1875 0514 48                    pha   
1876 0515 A2 02 2B 22           _BlockMove 
1877 051C
1878 051C 20 A3 05              jsr   ResetTPTPtr
1879 051F
1880 051F              TableInPlace                            ; 
1881 051F
1882 051F A5 1F                 lda   TSNum
1883 0521 C7 01                 cmp   [TPTRef]                 ; see if TS with this number
1884 0523              *			; already exists, or if we
1885 0523              *			; have to grow the table
1886 0523 90 05                 bcc   NoGrow
1887 0525
1888 0525
1889 0525 20 C2 05              jsr   GrowTables
1890 0528 A5 1F                 lda   TSNum
1891 052A
1892 052A              NoGrow                                  ; 
1893 052A
1894 052A              ;-----------------------------------------------
1895 052A              ;
1896 052A              ; Get original pointer and replace it with
1897 052A              ; new pointer.
1898 052A              ;
1899 052A 0A                    asl   a                        ; ts num is in a so double it
1900 052B 0A                    asl   a                        ; twice
1901 052C
1902 052C A8                    tay   
1903 052D B7 01                 lda   [TPTRef],y
1904 052F 85 05                 sta   OldTSPtr
1905 0531 A5 1B                 lda   FTablePtr
1906 0533 97 09                 sta   [NewTPTRef],y
1907 0535 C8                    iny   
1908 0536 C8                    iny                            ; move whole long word SEG 5 Jun 86
1909 0537 B7 01                 lda   [TPTRef],y
1910 0539 85 07                 sta   OldTSPtr+2               ; +2 instead of 1 to move whole
1911 053B A5 1D                 lda   FTablePtr+2              ; long word SEG 5 Jun 86
1912 053D 97 09                 sta   [NewTPTRef],y
1913 053F
1914 053F
1915 053F              ;-----------------------------------------------
1916 053F              ;
1917 053F              ; Now go thru the new table looking at each
1918 053F              ; function pointer.  For each function pointer
1919 053F              ; that is zero, we copy the old pointer to the
1920 053F              ; new table.  This way a patch does not have to
1921 053F              ; have pointers to functions that are not changing.
1922 053F              ;
1923 053F A7 1B                 lda   [FTablePtr]              ; get number of entries in new FuncTable
1924 0541 F0 1F                 beq   NoEntries
1925 0543 0A                    asl   a                        ; times 4 for num bytes to deal with
1926 0544 0A                    asl   a
1927 0545 A8                    tay   
1928 0546 88                    dey   
1929 0547 88                    dey   
1930 0548
1931 0548 B7 1B        PatchLoop lda   [FTablePtr],y           ; look at high word of entry
1932 054A D0 10                 bne   NewFunc1                 ; if not zero then must be new function
1933 054C 88                    dey                            ; pointer so skip it.
1934 054D 88                    dey   
1935 054E B7 1B                 lda   [FTablePtr],y            ; look at low word of entry
1936 0550 D0 0C                 bne   NewFunc2                 ; if not zer then must be new function
1937 0552              *			; pointer so skip it.
1938 0552
1939 0552 B7 05                 lda   [OldTSPtr],y             ; New entry was zero (both words)
1940 0554 97 1B                 sta   [FTablePtr],y            ; so copy the old entry to the new
1941 0556 C8                    iny                            ; entry.  (low word then high word)
1942 0557 C8                    iny   
1943 0558 B7 05                 lda   [OldTSPtr],y
1944 055A 97 1B                 sta   [FTablePtr],y
1945 055C
1946 055C 88           NewFunc1 dey                            ; now need to dec 4 times
1947 055D 88                    dey   
1948 055E 88           NewFunc2 dey                            ; if jumped here we have already
1949 055F 88                    dey                            ; decremented twice before getting here
1950 0560
1951 0560 10 E6                 bpl   PatchLoop
1952 0562
1953 0562              NoEntries                               ; 
1954 0562
1955 0562 A5 1F                 lda   TSNum                    ; now make the boot init call for this ts
1956 0564
1957 0564              ;-----------------------------------------------------------
1958 0564              ;
1959 0564              ; Special code to make AppleWorks GS work.  Never call the
1960 0564              ; BootInit code for the memory manager if the BootInit code
1961 0564              ; is still in ROM.
1962 0564              ;
1963 0564
1964 0564 C9 02 00              cmp   #$0002                   ; is it the memory manager?
1965 0567 D0 0D                 bne   @Continue
1966 0569
1967 0569 A0 06 00              ldy   #6                       ; if the address of  the init routine of the
1968 056C B7 1B                 lda   [FTablePtr],y            ; memory manager is in ROM, don't run it.  It
1969 056E C9 F0 00              cmp   #$00F0                   ; is not safe.
1970 0571 B0 15                 bcs   InitDone
1971 0573
1972 0573 A9 02 00              lda   #$0002
1973 0576
1974 0576              @Continue  
1975 0576 09 00 01              ora   #$0100
1976 0579 AA                    tax   
1977 057A 24 21                 bit   UserOrSystem
1978 057C 10 06                 bpl   SysInit
1979 057E 22 08 00 E1           jsl   $E10008
1980 0582 80 04                 bra   InitDone
1981 0584
1982 0584 22 00 00 E1  SysInit  jsl   $E10000
1983 0588
1984 0588
1985 0588 A2 00 00     InitDone ldx   #0
1986 058B
1987 058B              ErrorOut                                ; 
1988 058B
1989 058B A5 19                 lda   RTL1+4
1990 058D 85 21                 sta   RTL1+4+ParamSize
1991 058F A5 17                 lda   RTL1+2
1992 0591 85 1F                 sta   RTL1+2+ParamSize
1993 0593 A5 15                 lda   RTL1
1994 0595 85 1D                 sta   RTL1+ParamSize
1995 0597
1996 0597 2B                    pld                            ; restore zero page
1997 0598 3B                    tsc                            ; fix stack
1998 0599 18                    clc   
1999 059A 69 1C 00              adc   #ZPSize+ParamSize-1
2000 059D 1B                    tcs   
2001 059E
2002 059E 8A                    txa   
2003 059F C9 01 00              cmp   #1
2004 05A2 6B                    rtl   
2005 05A3
2006 05A3                       ENDP 
2007 05A3
2008 05A3
2009 05A3                       title 'ResetTPTPtr'
2010 05A3              ****************************************************************
2011 05A3              *
2012 05A3              ResetTPTPtr PROC 
2013 05A3              *
2014 05A3              * This routine copies the NewTPTRef back to the appropirate
2015 05A3              * master pointer.
2016 05A3              *
2017 05A3              *
2018 05A3              * Inputs:
2019 05A3              *	none
2020 05A3              *
2021 05A3              * Outputs:
2022 05A3              *	none
2023 05A3              *
2024 05A3              * External Refs:
2025 05A3              *	none
2026 05A3              *
2027 05A3              * Entry Points:
2028 05A3              *	none
2029 05A3              *
2030 05A3                       longa on                       ; mode
2031 05A3                       longi on
2032 05A3              *
2033 05A3              ****************************************************************
2034 05A3
2035 05A3
2036 05A3              TPTRef   equ   1                        ; this is where I put pointer to
2037 05A3              *			; old TPT
2038 05A3              OldTSPtr equ   TPTRef+4                 ; this is pointer to old FPT
2039 05A3              NewTPTRef equ   OldTSPtr+4              ; this is where I put pointer to
2040 05A3              *			; new TPT
2041 05A3              WAPTRef  equ   NewTPTRef+4              ; pointer to current WAPT
2042 05A3              *
2043 05A3              AHandle  equ   WAPTRef+4                ; this is temp storage for any
2044 05A3              *			; handle I need to deal with.
2045 05A3
2046 05A3              ZPSize   equ   AHandle+4
2047 05A3
2048 05A3              RTL1     equ   ZPSize
2049 05A3              RTL2     equ   RTL1+3
2050 05A3              FTablePtr equ   RTL2+3
2051 05A3              TSNum    equ   FTablePtr+4
2052 05A3              UserOrSystem equ   TSNum+2
2053 05A3
2054 05A3
2055 05A3 24 21                 bit   UserOrSystem
2056 05A5 30 0E                 bmi   UserPtrs2
2057 05A7
2058 05A7 A5 09                 lda   NewTPTRef                ; put new value into RAM pointer
2059 05A9 8F C0 03 E1           sta   >TPTPtr
2060 05AD A5 0B                 lda   NewTPTRef+2
2061 05AF 8F C2 03 E1           sta   >TPTPtr+2
2062 05B3 80 0C                 bra   done
2063 05B5
2064 05B5 A5 09        UserPtrs2 lda   NewTPTRef               ; put new value into RAM pointer
2065 05B7 8F C4 03 E1           sta   >U_TPTPtr
2066 05BB A5 0B                 lda   NewTPTRef+2
2067 05BD 8F C6 03 E1           sta   >U_TPTPtr+2
2068 05C1
2069 05C1 60           done     rts   
2070 05C2
2071 05C2                       ENDP 
2072 05C2
2073 05C2
2074 05C2
2075 05C2
2076 05C2                       title 'GrowTables'
2077 05C2              ****************************************************************
2078 05C2              *
2079 05C2              GrowTables PROC 
2080 05C2              *
2081 05C2              * This is the tricky code that grows TPT and WAP.
2082 05C2              *
2083 05C2              *
2084 05C2              * Inputs:
2085 05C2              *	none
2086 05C2              *
2087 05C2              * Outputs:
2088 05C2              *	none
2089 05C2              *
2090 05C2              * External Refs:
2091 05C2              *	none
2092 05C2              *
2093 05C2              * Entry Points:
2094 05C2              *	none
2095 05C2              *
2096 05C2                       longa on                       ; mode
2097 05C2                       longi on
2098 05C2              *
2099 05C2              ****************************************************************
2100 05C2
2101 05C2
2102 05C2              TPTRef   equ   1                        ; this is where I put pointer to
2103 05C2              *			; old TPT
2104 05C2              OldTSPtr equ   TPTRef+4                 ; this is pointer to old FPT
2105 05C2              NewTPTRef equ   OldTSPtr+4              ; this is where I put pointer to
2106 05C2              *			; new TPT
2107 05C2              WAPTRef  equ   NewTPTRef+4              ; pointer to current WAPT
2108 05C2              *
2109 05C2              AHandle  equ   WAPTRef+4                ; this is temp storage for any
2110 05C2              *			; handle I need to deal with.
2111 05C2
2112 05C2              ZPSize   equ   AHandle+4
2113 05C2
2114 05C2              RTL1     equ   ZPSize
2115 05C2              RTL2     equ   RTL1+3
2116 05C2              FTablePtr equ   RTL2+3
2117 05C2              TSNum    equ   FTablePtr+4
2118 05C2              UserOrSystem equ   TSNum+2
2119 05C2
2120 05C2 48                    pha                            ; make room for result
2121 05C3 48                    pha   
2122 05C4 D4 0B                 pei   NewTPTRef+2
2123 05C6 D4 09                 pei   NewTPTRef
2124 05C8 A2 02 1A 22           _FindHandle 
2125 05CF
2126 05CF 68                    pla   
2127 05D0 85 11                 sta   AHandle
2128 05D2 68                    pla   
2129 05D3 85 13                 sta   AHandle+2
2130 05D5
2131 05D5 D4 13                 pei   AHandle+2
2132 05D7 D4 11                 pei   AHandle
2133 05D9 A2 02 22 22           _HUnlock 
2134 05E0
2135 05E0 A5 1F                 lda   TSNum                    ; figure out how big we need it
2136 05E2 29 FF 00              and   #$00FF                   ; use ts num
2137 05E5 1A                    inc   a                        ; plus 1
2138 05E6 0A                    asl   a                        ; times 4
2139 05E7 0A                    asl   a
2140 05E8 F4 00 00              PushWord #0                    ; push size on stack
2141 05EB 48                    pha   
2142 05EC D4 13                 pei   AHandle+2
2143 05EE D4 11                 pei   AHandle
2144 05F0 A2 02 19 22           _SetHandleSize 
2145 05F7
2146 05F7 D4 13                 pei   AHandle+2                ; relock it
2147 05F9 D4 11                 pei   AHandle
2148 05FB A2 02 20 22           _HLock 
2149 0602
2150 0602 A7 11                 lda   [AHandle]                ; dereference it
2151 0604 85 09                 sta   NewTPTRef
2152 0606 A0 02 00              ldy   #2
2153 0609 B7 11                 lda   [AHandle],y
2154 060B 85 0B                 sta   NewTPTRef+2
2155 060D
2156 060D 20 A3 05              jsr   ResetTPTPtr              ; now fix the master pointer to TPT
2157 0610
2158 0610
2159 0610              ;-----------------------------------------------
2160 0610              ;
2161 0610              ; Since I grew the TPT, I also have to grow the
2162 0610              ; WAP.
2163 0610 48                    pha                            ; make room for result
2164 0611 48                    pha   
2165 0612 D4 0F                 pei   WAPTRef+2
2166 0614 D4 0D                 pei   WAPTRef
2167 0616 A2 02 1A 22           _FindHandle 
2168 061D
2169 061D 68                    pla   
2170 061E 85 11                 sta   AHandle
2171 0620 68                    pla   
2172 0621 85 13                 sta   AHandle+2
2173 0623
2174 0623 D4 13                 pei   AHandle+2
2175 0625 D4 11                 pei   AHandle
2176 0627 A2 02 22 22           _HUnlock 
2177 062E
2178 062E A5 1F                 lda   TSNum                    ; calc size
2179 0630 29 FF 00              and   #$00FF                   ; ts num +1 times 4
2180 0633 1A                    inc   a
2181 0634 0A                    asl   a
2182 0635 0A                    asl   a
2183 0636 F4 00 00              PushWord #0                    ; push size on stack
2184 0639 48                    pha   
2185 063A D4 13                 pei   AHandle+2
2186 063C D4 11                 pei   AHandle
2187 063E A2 02 19 22           _SetHandleSize 
2188 0645
2189 0645 D4 13                 pei   AHandle+2                ; relock it
2190 0647 D4 11                 pei   AHandle
2191 0649 A2 02 20 22           _HLock 
2192 0650
2193 0650 A7 11                 lda   [AHandle]                ; dereference it
2194 0652 85 0D                 sta   WAPTRef
2195 0654 A0 02 00              ldy   #2
2196 0657 B7 11                 lda   [AHandle],y
2197 0659 85 0F                 sta   WAPTRef+2
2198 065B
2199 065B 24 21                 bit   UserOrSystem
2200 065D 30 0E                 bmi   UserPtrs
2201 065F
2202 065F A5 0D                 lda   WAPTRef                  ; put new value into RAM pointer
2203 0661 8F C8 03 E1           sta   >WAPTPtr
2204 0665 A5 0F                 lda   WAPTRef+2
2205 0667 8F CA 03 E1           sta   >WAPTPtr+2
2206 066B 80 0C                 bra   done
2207 066D
2208 066D A5 0D        UserPtrs lda   WAPTRef                  ; put new value into RAM pointer
2209 066F 8F CC 03 E1           sta   >U_WAPTPtr
2210 0673 A5 0F                 lda   WAPTRef+2
2211 0675 8F CE 03 E1           sta   >U_WAPTPtr+2
2212 0679
2213 0679              done                                    ; 
2214 0679              ;-----------------------------------------------
2215 0679              ;
2216 0679              ; Now I must adjust the TSCount and put a pointer
2217 0679              ; to the dummy table in the new entries of the
2218 0679              ; TPT and zeros in new entries of the WAP
2219 0679              ;
2220 0679 A7 09                 lda   [NewTPTRef]
2221 067B 29 FF 00              and   #$00FF
2222 067E 0A                    asl   a
2223 067F 0A                    asl   a
2224 0680 A8                    tay   
2225 0681
2226 0681 A9 65 02     DummyFill lda   #DummyTable
2227 0684 97 09                 sta   [NewTPTRef],y
2228 0686 A9 00 00              lda   #0
2229 0689 97 0D                 sta   [WAPTRef],y
2230 068B C8                    iny   
2231 068C C8                    iny   
2232 068D A9 FE 00              lda   #^DummyTable
2233 0690 97 09                 sta   [NewTPTRef],y
2234 0692 A9 00 00              lda   #0
2235 0695 97 0D                 sta   [WAPTRef],y
2236 0697 C8                    iny   
2237 0698 C8                    iny   
2238 0699
2239 0699 A7 09                 lda   [NewTPTRef]              ; bump counter in TPT
2240 069B 1A                    inc   a
2241 069C 87 09                 sta   [NewTPTRef]
2242 069E A5 1F                 lda   TSNum                    ; compare counter with last entry
2243 06A0 29 FF 00              and   #$00FF                   ; counter should be lastentry + 1
2244 06A3 1A                    inc   a                        ; when done
2245 06A4 C7 09                 cmp   [NewTPTRef]
2246 06A6 F0 02                 beq   LoopDone
2247 06A8 B0 D7                 bcs   DummyFill
2248 06AA
2249 06AA
2250 06AA 60           LoopDone rts   
2251 06AB
2252 06AB
2253 06AB
2254 06AB
2255 06AB                       ENDP 
2256 06AB
2257 06AB
2258 06AB                       title 'GetFuncPtr'
2259 06AB              ****************************************************************
2260 06AB              *
2261 06AB              GetFuncPtr PROC 
2262 06AB              *
2263 06AB              * Returns pointer to a specified Function.
2264 06AB              *
2265 06AB              * Calling sequence:
2266 06AB              *
2267 06AB              *         PushPtr 0		; make room for result
2268 06AB              *         PushWord UserOrSystem
2269 06AB              *         PushWord TSNum,FuncNum
2270 06AB              *         _GetFuncPtr
2271 06AB              *
2272 06AB              *
2273 06AB              *
2274 06AB              * Inputs:
2275 06AB              *	UserOrSystemFlag : word
2276 06AB              *	ToolAndFuncNumber : word
2277 06AB              *
2278 06AB              * Outputs:
2279 06AB              *	FuncAdr : long
2280 06AB              *
2281 06AB              * External Refs:
2282 06AB              *	none
2283 06AB              *
2284 06AB              * Entry Points:
2285 06AB              *	none
2286 06AB              *
2287 06AB                       longa on                       ; mode
2288 06AB                       longi on
2289 06AB              *
2290 06AB              ****************************************************************
2291 06AB
2292 06AB
2293 06AB              TPTRef   equ   1
2294 06AB              FTableRef equ   TPTREf+4
2295 06AB              OrigDirect equ   FTableRef+4
2296 06AB              RTL1     equ   OrigDirect+2
2297 06AB              RTL2     equ   RTL1+3
2298 06AB              TSNum    equ   RTL2+3
2299 06AB              FuncNum  equ   TSNum+1
2300 06AB              UserOrSystem equ   FuncNum+1
2301 06AB              FuncPtr  equ   UserOrSystem+2
2302 06AB
2303 06AB
2304 06AB 0B                    phd                            ; save this thing
2305 06AC
2306 06AC 48                    pha                            ; put 8 bytes (four words)
2307 06AD 48                    pha   
2308 06AE 48                    pha   
2309 06AF 48                    pha   
2310 06B0
2311 06B0 3B                    tsc                            ; get stack pointer
2312 06B1 5B                    tcd                            ; make stack zp
2313 06B2
2314 06B2
2315 06B2 24 13                 bit   UserOrSystem
2316 06B4 30 0C                 bmi   UserPtrs
2317 06B6
2318 06B6 AF C0 03 E1           lda   >TPTPtr
2319 06BA 85 01                 sta   TPTRef
2320 06BC AF C1 03 E1           lda   >TPTPtr+1
2321 06C0 80 0A                 bra   GotPtr
2322 06C2
2323 06C2 AF C4 03 E1  UserPtrs lda   >U_TPTPtr
2324 06C6 85 01                 sta   TPTRef
2325 06C8 AF C5 03 E1           lda   >U_TPTPtr+1
2326 06CC 85 02        GotPtr   sta   TPTRef+1
2327 06CE
2328 06CE
2329 06CE A5 11                 lda   TSNum
2330 06D0 29 FF 00              and   #$FF
2331 06D3 F0 04                 beq   ABadTSNum
2332 06D5 C7 01                 cmp   [TPTRef]
2333 06D7 90 05                 bcc   GoOn1
2334 06D9
2335 06D9 A2 11 01     ABadTSNum ldx   #xBadTSNum
2336 06DC 80 2B                 bra   ErrorOut
2337 06DE
2338 06DE 0A           GoOn1    asl   a
2339 06DF 0A                    asl   a
2340 06E0
2341 06E0 A8                    tay   
2342 06E1 B7 01                 lda   [TPTRef],y
2343 06E3 85 05                 sta   FTableRef
2344 06E5 C8                    iny   
2345 06E6 B7 01                 lda   [TPTRef],y
2346 06E8 85 06                 sta   FTableRef+1
2347 06EA
2348 06EA A5 12                 lda   FuncNum
2349 06EC 29 FF 00              and   #$00FF
2350 06EF F0 04                 beq   aBadFNum
2351 06F1 C7 05                 cmp   [FTableRef]
2352 06F3 90 05                 bcc   GoOn2
2353 06F5
2354 06F5 A2 12 01     ABadFNum ldx   #xBadFuncNum
2355 06F8 80 0F                 bra   ErrorOut
2356 06FA
2357 06FA 0A           GoOn2    asl   a
2358 06FB 0A                    asl   a
2359 06FC
2360 06FC A8                    tay   
2361 06FD B7 05                 lda   [FTableRef],y
2362 06FF 85 15                 sta   FuncPtr
2363 0701 C8                    iny   
2364 0702 B7 05                 lda   [FTableRef],y
2365 0704 85 16                 sta   FuncPtr+1
2366 0706
2367 0706 A2 00 00              ldx   #0
2368 0709
2369 0709 68           ErrorOut pla                            ; clear off the 8 bytes on stack
2370 070A 68                    pla   
2371 070B 68                    pla   
2372 070C 68                    pla   
2373 070D
2374 070D 4C 11 FC              jmp   ErrOut4                  ; this goes out this way all the
2375 0710              *			; time because for no error
2376 0710              *			; x is zero
2377 0710
2378 0710                       ENDP 
2379 0710
2380 0710                       title 'GetWAP'
2381 0710              ****************************************************************
2382 0710              *
2383 0710              GetWAP   PROC 
2384 0710              *
2385 0710              * Returns the pointer to work area of specified tool number
2386 0710              *
2387 0710              *
2388 0710              * Possible Errors:
2389 0710              *     None.  I do not check for valid tool number!
2390 0710              *
2391 0710              *
2392 0710              * Calling Sequence
2393 0710              *
2394 0710              *     PushPtr 0		; make room for result
2395 0710              *     PushWord UserOrSystem
2396 0710              *     PushWord TSNum
2397 0710              *     _GetWAP
2398 0710              *
2399 0710              *
2400 0710              * Inputs:
2401 0710              *	UserOrSystemFlag : word
2402 0710              *	ToolNumber : word
2403 0710              *
2404 0710              * Outputs:
2405 0710              *	WAP value : LONG
2406 0710              *
2407 0710              * External Refs:
2408 0710              *	none
2409 0710              *
2410 0710              * Entry Points:
2411 0710              *	none
2412 0710              *
2413 0710                       longa on                       ; mode
2414 0710                       longi on
2415 0710              *
2416 0710              ****************************************************************
2417 0710
2418 0710
2419 0710              OrigDirect equ   1
2420 0710              RTL1     equ   OrigDirect+2
2421 0710              RTL2     equ   RTL1+3
2422 0710              TSNum    equ   RTL2+3
2423 0710              UserOrSystem equ   TSNum+2
2424 0710              WAP      equ   UserOrSystem+2
2425 0710
2426 0710              WAPTRef  equ   TSNum                    ; overwrite after read
2427 0710
2428 0710
2429 0710
2430 0710 0B                    phd                            ; save direct
2431 0711 3B                    tsc                            ; get stack pointer
2432 0712 5B                    tcd                            ; make stack zp
2433 0713
2434 0713 A6 09                 ldx   TSNum                    ; put this in x
2435 0715
2436 0715 24 0B                 bit   UserOrSystem
2437 0717 30 0C                 bmi   UserPtrs
2438 0719
2439 0719 AF C8 03 E1           lda   >WAPTPtr
2440 071D 85 09                 sta   WAPTRef
2441 071F AF CA 03 E1           lda   >WAPTPtr+2
2442 0723 80 0A                 bra   GotPtrs
2443 0725
2444 0725 AF CC 03 E1  UserPtrs lda   >U_WAPTPtr
2445 0729 85 09                 sta   WAPTRef
2446 072B AF CE 03 E1           lda   >U_WAPTPtr+2
2447 072F 85 0B        GotPtrs  sta   WAPTRef+2
2448 0731
2449 0731 8A                    txa   
2450 0732 29 FF 00              and   #$00FF
2451 0735 0A                    asl   a                        ; times 4
2452 0736 0A                    asl   a
2453 0737 A8                    tay                            ; put it in y
2454 0738 B7 09                 lda   [WAPTRef],y              ; get low word of WAP
2455 073A 85 0D                 sta   WAP
2456 073C C8                    iny                            ; get high word of WAP
2457 073D C8                    iny   
2458 073E B7 09                 lda   [WAPTRef],y
2459 0740 85 0F                 sta   WAP+2
2460 0742
2461 0742 4C 0E FC              jmp   EndCall4
2462 0745
2463 0745
2464 0745                       ENDP 
2465 0745
2466 0745
2467 0745
2468 0745                       title 'SetWAP'
2469 0745              ****************************************************************
2470 0745              *
2471 0745              SetWAP   PROC 
2472 0745              *
2473 0745              * Sets entry in WAP table to specified value for specified
2474 0745              * tool set.
2475 0745              *
2476 0745              * Possible Errors:
2477 0745              *        Bad Tool Set Number
2478 0745              *
2479 0745              *
2480 0745              * Calling Sequence
2481 0745              *
2482 0745              *        PushPtr WAP
2483 0745              *        PushWord UserOrSystem
2484 0745              *        PushWord TSNum
2485 0745              *        ldx
2486 0745              *        jsl Dispatch
2487 0745              *
2488 0745              *
2489 0745              *
2490 0745              * Inputs:
2491 0745              *	UserOrSystemFlag : word
2492 0745              *	ToolNumber : word
2493 0745              *	WAP value : LONG
2494 0745              *
2495 0745              * Outputs:
2496 0745              *	none
2497 0745              *
2498 0745              * External Refs:
2499 0745              *	none
2500 0745              *
2501 0745              * Entry Points:
2502 0745              *	none
2503 0745              *
2504 0745                       longa on                       ; mode
2505 0745                       longi on
2506 0745              *
2507 0745              ****************************************************************
2508 0745
2509 0745              TPTRef   equ   1
2510 0745              OrigDirect equ   TPTRef+4
2511 0745              RTL1     equ   OrigDirect+2
2512 0745              RTL2     equ   RTL1+3
2513 0745              WAP      equ   RTL2+3
2514 0745              TSNum    equ   WAP+4
2515 0745              UserOrSystem equ   TSNum+2
2516 0745
2517 0745              WAPTRef  equ   TSNum                    ; overwrite these
2518 0745
2519 0745
2520 0745 0B                    phd                            ; save this thing
2521 0746
2522 0746 F4 00 00              pea   0                        ; put two words on stack
2523 0749 F4 00 00              pea   0
2524 074C
2525 074C 3B                    tsc                            ; get stack pointer
2526 074D 5B                    tcd                            ; make stack zp
2527 074E
2528 074E A6 11                 ldx   TSNum                    ; get the TSNum
2529 0750
2530 0750 24 13                 bit   UserOrSystem
2531 0752 30 18                 bmi   UserPtrs
2532 0754
2533 0754 AF C8 03 E1           lda   >WAPTPtr
2534 0758 85 11                 sta   WAPTRef
2535 075A AF CA 03 E1           lda   >WAPTPtr+2
2536 075E 85 13                 sta   WAPTRef+2
2537 0760
2538 0760 AF C0 03 E1           lda   >TPTPtr
2539 0764 85 01                 sta   TPTRef
2540 0766 AF C2 03 E1           lda   >TPTPtr+2
2541 076A 80 16                 bra   GotPtrs
2542 076C
2543 076C AF CC 03 E1  UserPtrs lda   >U_WAPTPtr
2544 0770 85 11                 sta   WAPTRef
2545 0772 AF CE 03 E1           lda   >U_WAPTPtr+2
2546 0776 85 13                 sta   WAPTRef+2
2547 0778
2548 0778 AF C4 03 E1           lda   >U_TPTPtr
2549 077C 85 01                 sta   TPTRef
2550 077E AF C6 03 E1           lda   >U_TPTPtr+2
2551 0782 85 03        GotPtrs  sta   TPTRef+2
2552 0784
2553 0784 8A                    txa                            ; get ts num back from x
2554 0785 29 FF 00              and   #$00FF
2555 0788 F0 04                 beq   BadNum
2556 078A C7 01                 cmp   [TPTRef]
2557 078C 90 08                 bcc   ValidNum
2558 078E
2559 078E A2 11 01     BadNum   ldx   #xBadTSNum
2560 0791 68                    pla                            ; clean up the stack
2561 0792 68                    pla   
2562 0793 4C 3D FC              jmp   ErrOut8
2563 0796
2564 0796              ValidNum                                ; 
2565 0796 0A                    asl   a                        ; times 4
2566 0797 0A                    asl   a
2567 0798 A8                    tay                            ; put it in y
2568 0799 A5 0D                 lda   WAP
2569 079B 97 11                 sta   [WAPTRef],y
2570 079D C8                    iny   
2571 079E C8                    iny   
2572 079F A5 0F                 lda   WAP+2
2573 07A1 97 11                 sta   [WAPTRef],y
2574 07A3
2575 07A3
2576 07A3 68                    pla                            ; clean up the stack
2577 07A4 68                    pla   
2578 07A5 4C 3A FC              jmp   EndCall8
2579 07A8
2580 07A8
2581 07A8                       ENDP 
2582 07A8
2583 07A8
2584 07A8
2585 07A8                       title ' TLMemRoutines'
2586 07A8              ****************************************************************
2587 07A8              *
2588 07A8              TLMemRoutines PROC 
2589 07A8              *
2590 07A8              * Gets a handle of the size passed in the a-reg.  If GetMem
2591 07A8              * is used, attributes are passed from calling routine in
2592 07A8              * x-reg.  If TLNewhandle is used, attributes are TLAttributes.
2593 07A8              *
2594 07A8              *
2595 07A8              * Inputs:
2596 07A8              *    a-reg  Size of handle
2597 07A8              *    x-reg  attributes of handle (for GetMem only)
2598 07A8              *
2599 07A8              * Outputs:
2600 07A8              *    a-reg  Low word of handle (or error)
2601 07A8              *    x-reg  high word of handle
2602 07A8              *    carry  set on error, clear on success
2603 07A8              *
2604 07A8              * External Refs:
2605 07A8              *	none
2606 07A8              *
2607 07A8              * Entry Points:
2608 07A8                       export TLGetMem 
2609 07A8                       entry TLNewHandle 
2610 07A8              *
2611 07A8                       longa on                       ; mode
2612 07A8                       longi on
2613 07A8              *
2614 07A8              * Change History
2615 07A8              *
2616 07A8              * 06 Oct 87    Steven Glass
2617 07A8              *
2618 07A8              *    Added.
2619 07A8              *
2620 07A8              * 17 Jun 88	Steven Glass
2621 07A8              *
2622 07A8              * Combined this with TLNewHandle.  Code was almost identical
2623 07A8              * but duplicated.  By changing the calls to TLNewHandle to
2624 07A8              * use the a-reg and x-reg for output we could share code.
2625 07A8              *
2626 07A8              ****************************************************************
2627 07A8
2628 07A8              TLNewHandle  
2629 07A8 A2 08 80              ldx   #TLAttributes
2630 07AB              TLGetMem  
2631 07AB 48                    pha   
2632 07AC 48                    pha   
2633 07AD F4 00 00              pea   $0000
2634 07B0 48                    pha   
2635 07B1 F4 01 90              PushWord #TLUserID 
2636 07B4 DA                    phx   
2637 07B5 48                    pha   
2638 07B6 48                    pha   
2639 07B7 A2 02 09 22           _NewHandle 
2640 07BE B0 03                 bcs   oops
2641 07C0 68                    pla   
2642 07C1 FA                    plx   
2643 07C2
2644 07C2 60                    rts   
2645 07C3
2646 07C3 FA           oops     plx   
2647 07C4 FA                    plx   
2648 07C5 60                    rts   
2649 07C6
2650 07C6                       ENDP 
2651 07C6
2652 07C6                       EJECT 
2653 07C6              *******************************************************************************
2654 07C6              *
2655 07C6              AppleIIForever PROC 
2656 07C6              *
2657 07C6              * Description:	Wouldn't you like to know ...
2658 07C6              *
2659 07C6              *
2660 07C6              * Inputs:	None
2661 07C6              *
2662 07C6              * Outputs:	None
2663 07C6              *
2664 07C6              * External Refs:
2665 07C6              *
2666 07C6              * Entry Points:
2667 07C6              *
2668 07C6              *******************************************************************************
2669 07C6              Sound1   equ   $FF1000
2670 07C6              Sound2   equ   $FF1D00
2671 07C6
2672 07C6 08                    php   
2673 07C7 C2 30                 rep   #$30
2674 07C9
2675 07C9
2676 07C9 F4 00 00              pea   0
2677 07CC A2 08 06 22           _SoundToolStatus 
2678 07D3 68                    pla   
2679 07D4 D0 0C                 bne   @StartedAlready
2680 07D6
2681 07D6 F4 00 20              pea   $2000
2682 07D9 A2 08 02 22           _SoundStartup 
2683 07E0 B0 28                 bcs   @Error
2684 07E2              @StartedAlready  
2685 07E2              ; Now play the sound!
2686 07E2              @Again    
2687 07E2 F4 FF 7F              pea   #$7FFF
2688 07E5 A2 08 0F 22           _FFStopSound 
2689 07EC
2690 07EC E2 20                 sep   #$20                     ; crank the volume a little!
2691 07EE                       longa Off
2692 07EE AF CA 00 E1           lda   >$E100CA
2693 07F2 09 08                 ora   #$08
2694 07F4 8F CA 00 E1           sta   >$E100CA
2695 07F8 C2 20                 rep   #$20
2696 07FA                       longa On
2697 07FA
2698 07FA F4 01 00              pea   1
2699 07FD F4 FE 00 F4           PushLong #MyPBlock 
2700 0803 A2 08 0E 22           _FFStartSound 
2701 080A              @Error    
2702 080A 28                    plp   
2703 080B 6B                    rtl   
2704 080C              MyPBlock  
2705 080C 00 10 FF 00           DC L:Sound1
2706 0810 0C 00                 DC W:$000C
2707 0812 F6 00                 DC W:$00F6                     ; 5kHz 97
2708 0814 00 00                 DC W:$0000
2709 0816 0F 00                 DC W:$000F
2710 0818 1E 08 FE 00           DC L:MyOTHERPBlock
2711 081C FF 00                 DC W:$00FF
2712 081E              MyOTHERPBlock  
2713 081E 00 1D FF 00           DC L:Sound2
2714 0822 1F 00                 DC W:$001F
2715 0824 F6 00                 DC W:$00F6                     ; 5kHz 97
2716 0826 00 00                 DC W:$0000
2717 0828 0F 00                 DC W:$000F
2718 082A 00 00 00 00           DC L:0
2719 082E FF 00                 DC W:$00FF
2720 0830                       EndP 
2721 0830
2722 0830                       END   
2723 0830
